package cn.com.duiba.anticheat.center.api.remoteservice.rules;

import cn.com.duiba.anticheat.center.api.enums.RuleSceneEnum;
import cn.com.duiba.anticheat.center.api.result.rules.RuleChangeResultDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * Created by sty on 2018/7/31.
 */
@AdvancedFeignClient
public interface RemoteAntiBackendService {

  /**
   * 删除规则
   * @param scene
   * @param ruleName
   */
  RuleChangeResultDto delete(RuleSceneEnum scene, String ruleName);

  /**
   * 增加规则
   * @param scene
   * @param ruleContent
   * @param ruleName
   */
  RuleChangeResultDto add(RuleSceneEnum scene, String ruleContent, String ruleName);

  /**
   * 更新规则
   * @param scene
   * @param ruleContent
   * @param ruleName
   */
  RuleChangeResultDto update(RuleSceneEnum scene, String ruleContent, String ruleName);
}
