package cn.com.duiba.anticheat.center.api.result.goods;

import java.io.Serializable;
import java.util.List;

/**
 * 返回pass == true，那么通过验证，继续流程
 * 返回pass == false，那么需要再判断subResult
 * 如果subResult == 0，那么直接拒绝
 * 如果subResult == 1，那么需要用户输入验证码，验证码通过才可以继续兑换流程
 */
public class ACResultDto implements Serializable {

	private static final long serialVersionUID = 595440673289453161L;
	
	public static final int SUB_RESULT_DEFAULT = 0;	// 通过验证
	public static final int SUB_RESULT_NEED_IDENTIFYING_CODE = 1;	// 需要验证码
	
	private String message;
	private Boolean pass;
	private List<Long> debugIds;
	private Integer subResult;
	
	public ACResultDto(){}
	
	public ACResultDto(boolean pass, String message, List<Long> debugIds, Integer subResult) {
		this.pass = pass;
		this.message = message;
		this.debugIds = debugIds;
		this.subResult = subResult;
	}
	
	public String getMessage() {
		return message;
	}
	public void setMessage(String message) {
		this.message = message;
	}
	public Boolean getPass() {
		return pass;
	}
	public void setPass(Boolean pass) {
		this.pass = pass;
	}

	public List<Long> getDebugIds() {
		return debugIds;
	}

	public void setDebugIds(List<Long> debugIds) {
		this.debugIds = debugIds;
	}

	public Integer getSubResult() {
		return subResult;
	}

	public void setSubResult(Integer subResult) {
		this.subResult = subResult;
	}

	@Override
	public String toString() {
		return String.format(" pass=%s, message=%s, debugIds=%s, subResult=%s ", this.pass, this.message, this.debugIds, this.subResult);
	}
	
}
