package cn.com.duiba.anticheat.center.api.param;

import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.api.enums.ActRiskSenceEnum;
import cn.com.duiba.anticheat.center.api.enums.ProjectXLabelEnum;
import cn.com.duiba.anticheat.center.api.enums.RiskRoutBizEnum;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by fangdong on 2019/02/22
 */
public class RiskRuleEngineParam implements Serializable {
    private static final long serialVersionUID = 5700950316291800453L;

    /**
     * 活动来源 标明是 星速台活动还是非星速台活动
     */
    private RiskRoutBizEnum bizEnum;

    /**
     * 用户id
     */
    private Long consumerId;

    /**
     * 活动类型
     */
    private Integer activityType;

    /**
     * appId
     */
    private Long appId;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 入库id
     */
    private Long operatingId;

    /**
     * 项目id
     */
    private String projectId;

    /**
     * 星速台项目 标签
     */
    private ProjectXLabelEnum label;


    /**
     * 风控主场景: 1 提现,2 参与,3 发奖,4 兑换
     */
    private ActRiskSenceEnum scene;

    /**
     * 请求时间
     */
    private Date date;

    /**
     * ip
     */
    private String ip;

    /**
     * ua
     */
    private String ua;

    /**
     * 系统, 必须使用
     * {@link RequestParams}解析的os
     */
    private String os;

    /**
     * 支付宝账号
     */
    private String aliPayAccount;

    /**
     * 支付宝姓名
     */
    private String aliPayName;

    /**
     * 设备id
     */
    private String deviceId;

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getOperatingId() {
        return operatingId;
    }

    public void setOperatingId(Long operatingId) {
        this.operatingId = operatingId;
    }

    public ActRiskSenceEnum getScene() {
        return scene;
    }

    public void setScene(ActRiskSenceEnum scene) {
        this.scene = scene;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getUa() {
        return ua;
    }

    public void setUa(String ua) {
        this.ua = ua;
    }

    public String getOs() {
        return os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getAliPayAccount() {
        return aliPayAccount;
    }

    public void setAliPayAccount(String aliPayAccount) {
        this.aliPayAccount = aliPayAccount;
    }

    public String getAliPayName() {
        return aliPayName;
    }

    public void setAliPayName(String aliPayName) {
        this.aliPayName = aliPayName;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public RiskRoutBizEnum getBizEnum() {
        return bizEnum;
    }

    public void setBizEnum(RiskRoutBizEnum bizEnum) {
        this.bizEnum = bizEnum;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public ProjectXLabelEnum getLabel() {
        return label;
    }

    public void setLabel(ProjectXLabelEnum label) {
        this.label = label;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
