package cn.com.duiba.anticheat.center.api.remoteservice.activity;

import cn.com.duiba.anticheat.center.api.dto.ActivityBlackListDto;
import cn.com.duiba.anticheat.center.api.param.ActivityBlackListParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;


@AdvancedFeignClient
public interface RemoteActivityBlackListService {
    /**
     * 新增活动黑名单返回id
     *
     * @param record
     * @return
     */
    Long insert(ActivityBlackListDto record);

    /**
     * 更新活动黑名单
     *
     * @param record
     * @return
     */
    Integer updateById(ActivityBlackListDto record);


    /**
     * 根据customerId查询
     *
     * @param customerId
     * @return
     */
    ActivityBlackListDto findByCustomerId(Long customerId);

    /**
     * 查询单条记录详情
     *
     * @param id
     * @return
     */
    ActivityBlackListDto findById(Long id);


    /**
     * 删除某条记录
     *
     * @param id
     * @return
     */
    Integer deleteById(Long id);


    /**
     * 分页查询
     *
     * @param activityBlackListParam
     * @return
     */
    Page<ActivityBlackListDto> listByPage(ActivityBlackListParam activityBlackListParam);
}
