/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.dao.risk.impl;

import cn.com.duiba.anticheat.center.api.param.RiskRouteParam;
import cn.com.duiba.anticheat.center.biz.dao.BaseDao;
import cn.com.duiba.anticheat.center.biz.dao.DatabaseSchema;
import cn.com.duiba.anticheat.center.biz.dao.risk.RiskRouteConfigDao;
import cn.com.duiba.anticheat.center.biz.entity.risk.RiskRouteConfigEntity;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Repository;

@Repository
public class RiskRouteConfigDaoImpl
extends BaseDao
implements RiskRouteConfigDao {
    @PostConstruct
    private void init() {
        this.databaseSchema = DatabaseSchema.DEVELOPER_APP;
    }

    @Override
    public int save(RiskRouteConfigEntity riskRouteConfigEntity) {
        return this.insert("save", riskRouteConfigEntity);
    }

    @Override
    public int updateById(RiskRouteConfigEntity riskRouteConfigEntity) {
        return this.update("updateById", riskRouteConfigEntity);
    }

    @Override
    public RiskRouteConfigEntity getById(Long id) {
        return (RiskRouteConfigEntity)this.selectOne("getById", id);
    }

    @Override
    public List<RiskRouteConfigEntity> listByParams(RiskRouteParam param) {
        HashMap map = Maps.newHashMap();
        map.put("bizType", param.getBizType());
        map.put("projectLabel", param.getProjectLabel());
        map.put("activityType", param.getActivityType());
        map.put("projectId", param.getProjectId());
        map.put("scene", param.getScene());
        if (!Objects.isNull(param.getPageNo()) && !Objects.isNull(param.getPageSize())) {
            map.put("max", param.getPageSize());
            map.put("offset", (param.getPageNo() - 1) * param.getPageSize());
        }
        return this.selectList("listByParams", map);
    }

    @Override
    public int countByParams(RiskRouteParam param) {
        HashMap map = Maps.newHashMap();
        map.put("bizType", param.getBizType());
        map.put("projectLabel", param.getProjectLabel());
        map.put("activityType", param.getActivityType());
        map.put("projectId", param.getProjectId());
        map.put("scene", param.getScene());
        return (Integer)this.selectOne("countByParams", map);
    }
}

