/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.remoteservice.rules.impl;

import cn.com.duiba.anticheat.center.api.enums.RuleSceneEnum;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.api.remoteservice.rules.RemoteDuibaAntiService;
import cn.com.duiba.anticheat.center.biz.handler.AntiSceneHandler;
import cn.com.duiba.anticheat.center.biz.handler.AntiSceneHandlerRegister;
import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteDuibaAntiServiceImpl
implements RemoteDuibaAntiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteDuibaAntiServiceImpl.class);

    public boolean excute(RuleSceneEnum sceneEnum, DuibaBaseModel model) {
        if (sceneEnum == null || model == null) {
            return false;
        }
        try {
            AntiSceneHandler scenehandler = AntiSceneHandlerRegister.getHandler(sceneEnum.getType());
            if (scenehandler == null) {
                return false;
            }
            boolean result = scenehandler.isHitRule(model);
            if (!SpringEnvironmentUtils.isProdEnv() && LOGGER.isInfoEnabled()) {
                LOGGER.info("\u98ce\u63a7\u89c4\u5219\u8c03\u7528, scene={}, model={}, result={}", new Object[]{sceneEnum, JSON.toJSONString((Object)model), result});
            }
            if (PerfTestContext.isCurrentInPerfTestMode()) {
                return false;
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error("\u9632\u4f5c\u5f0a\u68c0\u6d4b\u51fa\u73b0\u5f02\u5e38,\u5f00\u59cb\u964d\u7ea7", (Throwable)e);
            return false;
        }
    }
}

