/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.activity.impl;

import cn.com.duiba.anticheat.center.api.dto.ActivityBlackListDto;
import cn.com.duiba.anticheat.center.api.param.ActivityBlackListParam;
import cn.com.duiba.anticheat.center.biz.dao.activity.ActivityBlackListDao;
import cn.com.duiba.anticheat.center.biz.service.activity.ActivityBlackListService;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.hutool.core.lang.Validator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ActivityBlackListServiceImpl
implements ActivityBlackListService {
    @Resource
    private ActivityBlackListDao activityBlackListDao;

    @Override
    public int deleteByPrimaryKey(Long id) {
        return this.activityBlackListDao.deleteByPrimaryKey(id);
    }

    @Override
    public Long insert(ActivityBlackListDto record) throws BizException {
        if (null == record || null == record.getAppId() || null == record.getCustomerId() || null == record.getProjectId() || StringUtils.isBlank((String)record.getIp()) || StringUtils.isBlank((String)record.getUa()) || null == record.getDevicedId() || null == record.getBannedSign() || StringUtils.isBlank((String)record.getBannedDescription())) {
            throw new BizException("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!Validator.isIpv4((CharSequence)record.getIp()) && !Validator.isIpv6((CharSequence)record.getIp())) {
            throw new BizException("ip\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        ActivityBlackListDto old = this.activityBlackListDao.findByCustomerId(record.getCustomerId());
        if (null == old) {
            this.activityBlackListDao.insert(record);
        } else if (old.getIsDel().booleanValue()) {
            record.setIsDel(Boolean.valueOf(false));
            record.setId(old.getId());
            this.activityBlackListDao.updateByPrimaryKey(record);
        } else {
            throw new BizException("\u5f53\u524d\u7528\u6237\u5df2\u5728\u9ed1\u540d\u5355\u5185");
        }
        return record.getId();
    }

    @Override
    public ActivityBlackListDto selectByPrimaryKey(Long id) {
        return this.activityBlackListDao.selectByPrimaryKey(id);
    }

    @Override
    public int updateByPrimaryKey(ActivityBlackListDto record) {
        return this.activityBlackListDao.updateByPrimaryKey(record);
    }

    @Override
    public Page<ActivityBlackListDto> listByPage(ActivityBlackListParam activityBlackListParam) {
        List<ActivityBlackListDto> list = this.activityBlackListDao.listByCondition(activityBlackListParam);
        Integer count = this.activityBlackListDao.selectCountByCondition(activityBlackListParam);
        Page dtoPage = new Page();
        dtoPage.setTotalCount(count.intValue());
        dtoPage.setList(list);
        return dtoPage;
    }

    @Override
    public Boolean findByCustomerId(Long customerId) throws BizException {
        if (null == customerId) {
            throw new BizException("customerId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Boolean res = true;
        ActivityBlackListDto old = this.activityBlackListDao.findByCustomerId(customerId);
        if (old == null || old.getIsDel().booleanValue()) {
            res = false;
        }
        return res;
    }

    @Override
    public Long deleteByCustomerId(Long customerId) throws BizException {
        if (null == customerId) {
            throw new BizException("customerId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ActivityBlackListDto old = this.activityBlackListDao.findByCustomerId(customerId);
        if (old == null || old.getIsDel().booleanValue()) {
            throw new BizException("\u7528\u6237\u4e0d\u5728\u9ed1\u540d\u5355\u4e2d");
        }
        this.activityBlackListDao.deleteByPrimaryKey(old.getId());
        return old.getId();
    }
}

