/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.risk.impl;

import cn.com.duiba.anticheat.center.api.dto.RiskRouteDto;
import cn.com.duiba.anticheat.center.api.enums.ActRiskSenceEnum;
import cn.com.duiba.anticheat.center.api.enums.ProjectXLabelEnum;
import cn.com.duiba.anticheat.center.api.enums.RiskRoutBizEnum;
import cn.com.duiba.anticheat.center.api.param.RiskRouteParam;
import cn.com.duiba.anticheat.center.api.param.RouteMatchingParam;
import cn.com.duiba.anticheat.center.biz.constant.RedisKeyFactory;
import cn.com.duiba.anticheat.center.biz.dao.risk.RiskRouteConfigDao;
import cn.com.duiba.anticheat.center.biz.entity.risk.RiskRouteConfigEntity;
import cn.com.duiba.anticheat.center.biz.service.risk.RiskRouteService;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RiskRouteServiceImpl
implements RiskRouteService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RiskRouteServiceImpl.class);
    @Autowired
    private RiskRouteConfigDao dao;
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;

    @Override
    public boolean insert(RiskRouteDto dto) throws BizException {
        if (Objects.isNull(dto) || RiskRoutBizEnum.getByType((Integer)dto.getBizType()) == null || ActRiskSenceEnum.getEnumByValue((Integer)dto.getScene()) == null || StringUtils.isBlank((String)dto.getSceneIdentity()) || dto.getPunishWay() == null || StringUtils.isBlank((String)dto.getCopy())) {
            LOGGER.warn("\u65b0\u589e\u98ce\u63a7\u8def\u7531\u914d\u7f6e\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7,\u5165\u53c2={}", (Object)dto);
            return false;
        }
        List<RiskRouteConfigEntity> entities = this.checkExist(dto);
        if (CollectionUtils.isNotEmpty(entities)) {
            throw new BizException("\u5f53\u524d\u6d3b\u52a8\u5df2\u914d\u7f6e\u8be5\u573a\u666f");
        }
        if (this.dao.save((RiskRouteConfigEntity)BeanUtils.copy((Object)dto, RiskRouteConfigEntity.class)) > 0) {
            this.advancedCacheClient.remove(this.getKey(dto.getBizType()));
            return true;
        }
        return false;
    }

    @Override
    public boolean updateById(RiskRouteDto dto) throws BizException {
        List<RiskRouteConfigEntity> entities;
        if (Objects.isNull(dto) || dto.getId() == null) {
            LOGGER.warn("\u66f4\u65b0\u98ce\u63a7\u8def\u7531\u914d\u7f6e\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7,\u5165\u53c2={}", (Object)dto);
            return false;
        }
        RiskRouteConfigEntity entity = this.dao.getById(dto.getId());
        if (entity == null) {
            throw new BizException("id\u4e0d\u5b58\u5728");
        }
        if (dto.getDeleted() != null && dto.getDeleted() != 1 && CollectionUtils.isNotEmpty(entities = this.checkExist(dto)) && !entities.get(0).getId().equals(dto.getId())) {
            throw new BizException("\u5f53\u524d\u914d\u7f6e\u5df2\u5b58\u5728");
        }
        if (this.dao.updateById((RiskRouteConfigEntity)BeanUtils.copy((Object)dto, RiskRouteConfigEntity.class)) > 0) {
            this.advancedCacheClient.remove(this.getKey(dto.getBizType()));
            if (!Objects.equals(dto.getBizType(), entity.getBizType())) {
                this.advancedCacheClient.remove(this.getKey(entity.getBizType()));
            }
            return true;
        }
        return false;
    }

    @Override
    public List<RiskRouteDto> getListByParam(RiskRouteParam param) {
        return BeanUtils.copyList(this.dao.listByParams(param), RiskRouteDto.class);
    }

    @Override
    public int countByParam(RiskRouteParam param) {
        return this.dao.countByParams(param);
    }

    @Override
    public RiskRouteDto routeMatch(RouteMatchingParam param) {
        RiskRouteCacheWithBizType actCache = new RiskRouteCacheWithBizType(param.getBizEnum().getType());
        List routeConfs = (List)this.advancedCacheClient.getWithCacheLoader(this.getKey(param.getBizEnum().getType()), 5, TimeUnit.MINUTES, (CacheLoader)actCache);
        Integer scene = param.getSenceEnum().getValue();
        if (CollectionUtils.isEmpty((Collection)routeConfs)) {
            return this.getOrtherRoute(scene);
        }
        if (Objects.equals(param.getBizEnum(), RiskRoutBizEnum.COMMON_ACTIVITY)) {
            if (param.getActivityType() == null) {
                return this.getOrtherRoute(scene);
            }
            Optional<RiskRouteConfigEntity> optional = routeConfs.stream().filter(e -> Objects.equals(e.getActivityType(), param.getActivityType()) && Objects.equals(e.getScene(), scene)).findAny();
            return optional.isPresent() ? (RiskRouteDto)BeanUtils.copy((Object)optional.get(), RiskRouteDto.class) : this.getOrtherRoute(scene);
        }
        Integer label = param.getLabel().getCode();
        if (Objects.equals(param.getLabel(), ProjectXLabelEnum.CUSTOM)) {
            Optional<RiskRouteConfigEntity> optional = routeConfs.stream().filter(e -> Objects.equals(e.getProjectLabel(), label) && Objects.equals(e.getScene(), scene) && StringUtils.equals((String)e.getProjectId(), (String)param.getProjectId())).findAny();
            return optional.isPresent() ? (RiskRouteDto)BeanUtils.copy((Object)optional.get(), RiskRouteDto.class) : this.getOrtherRoute(scene);
        }
        Optional<RiskRouteConfigEntity> optional = routeConfs.stream().filter(e -> Objects.equals(e.getProjectLabel(), label) && Objects.equals(e.getScene(), scene)).findAny();
        return optional.isPresent() ? (RiskRouteDto)BeanUtils.copy((Object)optional.get(), RiskRouteDto.class) : this.getOrtherRoute(scene);
    }

    private RiskRouteDto getOrtherRoute(Integer scene) {
        Integer elseBizType = RiskRoutBizEnum.ELSE.getType();
        RiskRouteCacheWithBizType elseCache = new RiskRouteCacheWithBizType(elseBizType);
        List routeConfs = (List)this.advancedCacheClient.getWithCacheLoader(this.getKey(elseBizType), 5, TimeUnit.MINUTES, (CacheLoader)elseCache);
        Optional<RiskRouteConfigEntity> optional = routeConfs.stream().filter(e -> Objects.equals(e.getScene(), scene)).findAny();
        return optional.isPresent() ? (RiskRouteDto)BeanUtils.copy((Object)optional.get(), RiskRouteDto.class) : null;
    }

    private List<RiskRouteConfigEntity> checkExist(RiskRouteDto dto) throws BizException {
        RiskRouteParam queryParam = new RiskRouteParam();
        queryParam.setBizType(dto.getBizType());
        queryParam.setScene(dto.getScene());
        if (Objects.equals(dto.getBizType(), RiskRoutBizEnum.COMMON_ACTIVITY.getType())) {
            if (dto.getActivityType() == null) {
                throw new BizException("\u98ce\u63a7\u8def\u7531\u914d\u7f6e\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7,\u5165\u53c2ActivityType\u4e3a\u7a7a");
            }
            queryParam.setActivityType(dto.getActivityType());
        } else if (Objects.equals(dto.getBizType(), RiskRoutBizEnum.PROJECTX_ACTIVITY.getType())) {
            if (dto.getProjectLabel() == null) {
                throw new BizException("\u98ce\u63a7\u8def\u7531\u914d\u7f6e\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7,\u5165\u53c2ProjectLabel\u4e3a\u7a7a");
            }
            queryParam.setProjectLabel(dto.getProjectLabel());
            if (Objects.equals(dto.getProjectLabel(), ProjectXLabelEnum.CUSTOM.getCode())) {
                if (StringUtils.isBlank((String)dto.getProjectId())) {
                    throw new BizException("\u98ce\u63a7\u8def\u7531\u914d\u7f6e\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7,\u5165\u53c2ProjectId\u4e3a\u7a7a");
                }
                queryParam.setProjectId(dto.getProjectId());
            }
        }
        return this.dao.listByParams(queryParam);
    }

    private String getKey(Integer bizType) {
        return RedisKeyFactory.K031.toString() + bizType;
    }

    private class RiskRouteCacheWithBizType
    implements CacheLoader<List<RiskRouteConfigEntity>> {
        Integer bizType;

        public RiskRouteCacheWithBizType(Integer bizType) {
            this.bizType = bizType;
        }

        public List<RiskRouteConfigEntity> load() {
            RiskRouteParam param = new RiskRouteParam();
            param.setBizType(this.bizType);
            List<RiskRouteConfigEntity> riskRouteConfigEntities = RiskRouteServiceImpl.this.dao.listByParams(param);
            return CollectionUtils.isEmpty(riskRouteConfigEntities) ? Collections.emptyList() : riskRouteConfigEntities;
        }
    }
}

