/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.risk.impl;

import cn.com.duiba.anticheat.center.api.dto.CustomRiskBO;
import cn.com.duiba.anticheat.center.api.dto.RiskRuleEngineResultDto;
import cn.com.duiba.anticheat.center.api.enums.ActRiskSenceEnum;
import cn.com.duiba.anticheat.center.api.enums.RiskDecisionEnum;
import cn.com.duiba.anticheat.center.api.enums.RiskSceneMappingEnum;
import cn.com.duiba.anticheat.center.api.param.RiskRuleEngineParam;
import cn.com.duiba.anticheat.center.api.param.RiskRuleParam;
import cn.com.duiba.anticheat.center.biz.service.risk.RiskRuleEngineService;
import cn.com.duiba.anticheat.center.common.exceptions.AnticheatException;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.developer.center.api.utils.WhiteAccessUtil;
import cn.com.duiba.tuia.risk.engine.api.remote.RemoteRuleEngineService;
import cn.com.duiba.tuia.risk.engine.api.req.DuiBaRuleEngineParam;
import cn.com.duiba.tuia.risk.engine.api.rsp.RuleEngineResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="riskRuleEngineService")
public class RiskRuleEngineServiceImpl
implements RiskRuleEngineService {
    private static final Logger log = LoggerFactory.getLogger(RiskRuleEngineServiceImpl.class);
    private static final String SOURCE = "duiba";
    private static final String CUSTOM_RISK = "DZFK_lvcong";
    @Resource
    private RemoteRuleEngineService remoteRuleEngineService;

    @Override
    public RiskRuleEngineResultDto execute(RiskRuleParam param) {
        if (param == null) {
            throw new AnticheatException("\u53c2\u6570\u9519\u8bef");
        }
        DuiBaRuleEngineParam request = new DuiBaRuleEngineParam();
        request.setConsumerId(param.getConsumerId().toString());
        request.setActivityType(param.getActivityType());
        request.setMediaId(param.getAppId().toString());
        request.setActivityShortId(param.getActivityId());
        request.setActivityId(param.getOperatingId());
        request.setSceneKey(param.getScene().getCode());
        request.setDuibaScene(param.getScene().getType());
        request.setDate(param.getDate());
        request.setIp(param.getIp());
        request.setUa(DigestUtils.md5Hex((String)param.getUa()));
        request.setPlatform(param.getOs());
        request.setAliPayAccount(param.getAliPayAccount());
        request.setAliPayName(param.getAliPayName());
        request.setSource(SOURCE);
        request.setDeviceId(param.getDeviceId());
        RuleEngineResult response = null;
        try {
            if (SpringEnvironmentUtils.isTestEnv() && log.isInfoEnabled()) {
                log.info("\u98ce\u63a7\u89c4\u5219\u5f15\u64ce -\u5165\u53c2\uff1a={}", (Object)JSONObject.toJSONString((Object)request));
            }
            if ((response = this.remoteRuleEngineService.operator4Duiba(request)) == null || !response.isSuccess()) {
                throw new AnticheatException("\u98ce\u63a7\u89c4\u5219\u5f15\u64ce\u6267\u884c\u5f02\u5e38");
            }
        }
        catch (Exception e) {
            log.error("\u98ce\u63a7\u89c4\u5219\u5f15\u64ce\u6267\u884c\u5f02\u5e38, param={}, request={}, response={}", new Object[]{param, JSON.toJSONString((Object)request), JSON.toJSONString((Object)response), e});
            throw e;
        }
        RiskRuleEngineResultDto result = new RiskRuleEngineResultDto();
        result.setDecision(response.isReject() ? RiskDecisionEnum.REJECT : RiskDecisionEnum.ACCEPT);
        return result;
    }

    @Override
    public RiskRuleEngineResultDto executeByRoute(RiskRuleEngineParam param, String sceneKey) {
        if (param == null) {
            throw new AnticheatException("\u53c2\u6570\u9519\u8bef");
        }
        DuiBaRuleEngineParam request = new DuiBaRuleEngineParam();
        request.setConsumerId(param.getConsumerId().toString());
        request.setActivityType(param.getActivityType());
        request.setMediaId(param.getAppId().toString());
        request.setActivityShortId(param.getActivityId());
        request.setActivityId(param.getOperatingId());
        request.setSceneKey(this.getSceneKey(param, sceneKey));
        request.setDuibaScene(RiskSceneMappingEnum.getEnumByActSence((ActRiskSenceEnum)param.getScene()).getType());
        request.setDate(param.getDate());
        request.setIp(param.getIp());
        request.setUa(StringUtils.isBlank((CharSequence)param.getUa()) ? null : DigestUtils.md5Hex((String)StringUtils.lowerCase((String)param.getUa())));
        request.setPlatform(param.getOs());
        request.setAliPayAccount(param.getAliPayAccount());
        request.setAliPayName(param.getAliPayName());
        request.setSource(SOURCE);
        request.setDeviceId(param.getDeviceId());
        request.setAssistedUserId(param.getAssistedUserId());
        request.setItemId(param.getItemId());
        request.setPhone(param.getPhone());
        if (StringUtils.isNotBlank((CharSequence)param.getAccount())) {
            request.setAccount(param.getAccount());
        }
        RuleEngineResult response = null;
        boolean isTestOrPreEnv = SpringEnvironmentUtils.isTestEnv() || SpringEnvironmentUtils.isPreEnv();
        try {
            if (isTestOrPreEnv && log.isInfoEnabled()) {
                log.info("\u98ce\u63a7\u89c4\u5219\u5f15\u64ce -\u5165\u53c2\uff1a={}", (Object)JSONObject.toJSONString((Object)request));
            }
            response = this.remoteRuleEngineService.operator4Duiba(request);
            if (isTestOrPreEnv) {
                log.info("\u98ce\u63a7\u89c4\u5219\u5f15\u64ce -\u54cd\u5e94\uff1a={}", (Object)JSONObject.toJSONString((Object)response));
            }
            if (response == null || !response.isSuccess()) {
                throw new AnticheatException("\u98ce\u63a7\u89c4\u5219\u5f15\u64ce\u6267\u884c\u5f02\u5e38");
            }
        }
        catch (Exception e) {
            log.error("\u98ce\u63a7\u89c4\u5219\u5f15\u64ce\u6267\u884c\u5f02\u5e38, param={}, request={}, response={}", new Object[]{param, JSON.toJSONString((Object)request), JSON.toJSONString((Object)response), e});
            throw e;
        }
        RiskRuleEngineResultDto result = new RiskRuleEngineResultDto();
        result.setDecision(response.isReject() ? RiskDecisionEnum.REJECT : RiskDecisionEnum.ACCEPT);
        if (response.isReject() && log.isInfoEnabled()) {
            log.info("\u98ce\u63a7\u62e6\u622a,\u53c2\u6570={},sceneKey={}", (Object)JSONObject.toJSONString((Object)param), (Object)sceneKey);
        }
        return result;
    }

    public String getSceneKey(RiskRuleEngineParam param, String sceneKey) {
        if (Objects.isNull(param) || param.getAppId() == null || Objects.isNull(param.getScene())) {
            return sceneKey;
        }
        String riskConfigStr = WhiteAccessUtil.selectWhiteListJsonConfig((String)CUSTOM_RISK);
        if (StringUtils.isBlank((CharSequence)riskConfigStr)) {
            return sceneKey;
        }
        if (!riskConfigStr.contains(param.getAppId().toString())) {
            return sceneKey;
        }
        try {
            List customRiskBOList = JSON.parseArray((String)riskConfigStr, CustomRiskBO.class);
            if (CollectionUtils.isEmpty((Collection)customRiskBOList)) {
                return sceneKey;
            }
            for (CustomRiskBO customRiskBO : customRiskBOList) {
                if (customRiskBO == null || customRiskBO.getRiskScene() == null || CollectionUtils.isEmpty((Collection)customRiskBO.getAppIds()) || StringUtils.isBlank((CharSequence)customRiskBO.getSceneKey()) || !Objects.equals(customRiskBO.getRiskScene(), param.getScene().getValue()) || !customRiskBO.getAppIds().contains(param.getAppId())) continue;
                log.info("\u5b9a\u5236\u98ce\u63a7\uff0cparam:{}, sceneKey:{}", (Object)JSON.toJSONString((Object)param), (Object)customRiskBO.getSceneKey());
                return customRiskBO.getSceneKey();
            }
        }
        catch (Exception e) {
            log.warn("\u5b9a\u5236\u98ce\u63a7\u89e3\u6790\u5f02\u5e38\uff0c\u8d70\u901a\u7528\u98ce\u63a7\uff0cparam:{}, sceneKey:{}, riskConfig:{}", new Object[]{JSON.toJSONString((Object)param), sceneKey, riskConfigStr, e});
        }
        return sceneKey;
    }
}

