/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.risk.impl;

import cn.com.duiba.anticheat.center.api.dto.RiskWhiteListDto;
import cn.com.duiba.anticheat.center.api.enums.ActRiskSenceEnum;
import cn.com.duiba.anticheat.center.api.enums.RiskWhiteListTypeEnum;
import cn.com.duiba.anticheat.center.api.param.RiksWhitelistMatchingParam;
import cn.com.duiba.anticheat.center.api.param.RiskWhiteListParam;
import cn.com.duiba.anticheat.center.biz.constant.RedisKeyFactory;
import cn.com.duiba.anticheat.center.biz.dao.risk.RiskWhiteListDao;
import cn.com.duiba.anticheat.center.biz.entity.risk.RiskWhiteListEntity;
import cn.com.duiba.anticheat.center.biz.service.risk.RiskWhiteListService;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RiskWhiteListServiceImpl
implements RiskWhiteListService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RiskWhiteListServiceImpl.class);
    private static final String SPACE = "_";
    @Autowired
    private RiskWhiteListDao riskWhiteListDao;
    @Autowired
    private RedisTemplate redisTemplate;

    @Override
    @Transactional(value="developer_app")
    public int insert(RiskWhiteListDto dto) throws BizException {
        if (Objects.isNull(dto)) {
            return 0;
        }
        RiskWhiteListParam param = new RiskWhiteListParam();
        param.setAppIds((List)Lists.newArrayList((Object[])new Long[]{dto.getAppId()}));
        param.setType(RiskWhiteListTypeEnum.getEnumByValue((Integer)dto.getType()));
        param.setConsumerId(dto.getConsumerId());
        param.setRiskSence(ActRiskSenceEnum.getEnumByValue((Integer)dto.getRiskSence()));
        param.setIp(dto.getIp());
        if (this.countByAppConsumerTypeSences(param) > 0) {
            throw new BizException("\u8be5\u914d\u7f6e\u5df2\u5b58\u5728");
        }
        int result = this.riskWhiteListDao.insert((RiskWhiteListEntity)BeanUtils.copy((Object)dto, RiskWhiteListEntity.class));
        if (result > 0) {
            this.redisTemplate.delete((Object)this.getKey(ActRiskSenceEnum.getEnumByValue((Integer)dto.getRiskSence())));
        }
        return result;
    }

    @Override
    @Transactional(value="developer_app")
    public int updateById(RiskWhiteListDto dto) {
        if (Objects.isNull(dto) || Objects.isNull(dto.getId())) {
            return 0;
        }
        RiskWhiteListEntity entity = this.riskWhiteListDao.getById(dto.getId());
        if (Objects.isNull(entity)) {
            return 0;
        }
        int result = this.riskWhiteListDao.updateById((RiskWhiteListEntity)BeanUtils.copy((Object)dto, RiskWhiteListEntity.class));
        if (result > 0) {
            this.redisTemplate.delete((Object)this.getKey(ActRiskSenceEnum.getEnumByValue((Integer)entity.getRiskSence())));
            if (dto.getRiskSence() != null && !Objects.equals(dto.getRiskSence(), entity.getRiskSence())) {
                this.redisTemplate.delete((Object)this.getKey(ActRiskSenceEnum.getEnumByValue((Integer)dto.getRiskSence())));
            }
        }
        return result;
    }

    @Override
    public RiskWhiteListEntity getById(Long id) {
        return this.riskWhiteListDao.getById(id);
    }

    @Override
    public List<RiskWhiteListEntity> listByAppConsumerTypeSences(RiskWhiteListParam param) {
        return this.riskWhiteListDao.listByAppConsumerTypeSences(param);
    }

    @Override
    public int countByAppConsumerTypeSences(RiskWhiteListParam param) {
        return this.riskWhiteListDao.countByAppConsumerTypeSences(param);
    }

    @Override
    public Boolean riskWhitelistMatching(RiksWhitelistMatchingParam riksWhitelistMatchingParam) throws BizException {
        Long appId = riksWhitelistMatchingParam.getAppId();
        Long consumerId = riksWhitelistMatchingParam.getConsumerId();
        ActRiskSenceEnum riskSence = riksWhitelistMatchingParam.getRiskSence();
        String ip = riksWhitelistMatchingParam.getIp();
        this.checkParam(appId, consumerId, riskSence, ip);
        String redisKey = this.getKey(riskSence);
        if (BooleanUtils.isNotTrue((Boolean)this.redisTemplate.hasKey((Object)redisKey))) {
            Object[] array;
            RiskWhiteListParam param = new RiskWhiteListParam();
            param.setPageSize(null);
            param.setPageNo(null);
            param.setRiskSence(riskSence);
            List<RiskWhiteListEntity> list = this.riskWhiteListDao.listByAppConsumerTypeSences(param);
            if (CollectionUtils.isNotEmpty(list)) {
                array = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    array[i] = this.getValueByType(list.get(i));
                }
            } else {
                array = new String[]{"none"};
            }
            this.redisTemplate.opsForSet().add((Object)redisKey, array);
            this.redisTemplate.expire((Object)redisKey, 10L, TimeUnit.MINUTES);
        }
        SetOperations setOperations = this.redisTemplate.opsForSet();
        return BooleanUtils.isTrue((Boolean)this.redisTemplate.hasKey((Object)redisKey)) && (setOperations.isMember((Object)redisKey, (Object)this.buildRedisSetValue(1, String.valueOf(appId))) != false || setOperations.isMember((Object)redisKey, (Object)this.buildRedisSetValue(2, String.valueOf(consumerId))) != false || setOperations.isMember((Object)redisKey, (Object)this.buildRedisSetValue(3, String.valueOf(ip))) != false);
    }

    @Override
    public List<RiskWhiteListDto> selectByMultValues(Long appId, Integer riskType, Integer riskScene, List<String> riskValues) {
        return this.riskWhiteListDao.selectByMultValues(appId, riskType, riskScene, riskValues);
    }

    @Override
    public void batchDeleteByPrimaryKey(List<Long> ids) {
        this.riskWhiteListDao.batchDeleteByPrimaryKey(ids);
    }

    @Override
    public Boolean checkIpExist(Long appId, Integer riskScene, String riskValue) {
        int i = this.riskWhiteListDao.checkIpExist(appId, riskScene, riskValue);
        return i <= 0;
    }

    private String getValueByType(RiskWhiteListEntity e) throws BizException {
        String result = "";
        switch (e.getType()) {
            case 1: {
                result = this.buildRedisSetValue(e.getType(), String.valueOf(e.getAppId()));
                break;
            }
            case 2: {
                result = this.buildRedisSetValue(e.getType(), String.valueOf(e.getConsumerId()));
                break;
            }
            case 3: {
                result = this.buildRedisSetValue(e.getType(), String.valueOf(e.getIp()));
                break;
            }
            default: {
                throw new BizException(String.format("\u767d\u540d\u5355\u7c7b\u578b\u5f02\u5e38%s", e.getType()));
            }
        }
        return result;
    }

    private String buildRedisSetValue(Integer type, String e) throws BizException {
        if (type == null) {
            throw new BizException(String.format("\u767d\u540d\u5355\u7c7b\u578b\u5f02\u5e38%s", type));
        }
        return String.format("%s%s%s", type, SPACE, e);
    }

    private void checkParam(Long appId, Long consumerId, ActRiskSenceEnum riskSence, String ip) throws BizException {
        if (Objects.isNull(appId)) {
            throw new BizException("\u53c2\u6570{appId}\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (Objects.isNull(consumerId)) {
            throw new BizException("\u53c2\u6570{consumerId}\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (Objects.isNull(riskSence)) {
            throw new BizException("\u53c2\u6570{riskSence}\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)ip)) {
            throw new BizException("\u53c2\u6570{ip}\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
    }

    private String getKey(ActRiskSenceEnum riskSence) {
        return RedisKeyFactory.K035.toString() + riskSence.getValue();
    }
}

