/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.enums.HbaseKeyEnum;
import cn.com.duiba.anticheat.center.biz.service.hbase.DuibaHbaseRiskService;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlipayAccountHandller
implements DataServerHandler {
    @Autowired
    private DuibaHbaseRiskService duibaHbaseRiskService;
    @Autowired
    private SwitchService switchService;

    @PostConstruct
    public void init() {
        DataServerHandlerManager.registerHandler(this);
    }

    @Override
    public <T extends DuibaBaseModel> void countService(T model) {
    }

    @Override
    public Long getService(DuibaActivityModel model) {
        return 0L;
    }

    @Override
    public Long setAndGetService(DuibaActivityModel model) {
        if (model == null) {
            return 0L;
        }
        String alipayAccount = model.getAlipayAccount();
        if (!this.switchService.getIsOpen(AnticheatSwitchEnum.ALIPAY_ACCOUNT) || StringUtils.isEmpty((CharSequence)alipayAccount)) {
            return 0L;
        }
        String userKey = this.hbaseKey(alipayAccount);
        return this.duibaHbaseRiskService.increaseByKey(userKey, 1L);
    }

    private String hbaseKey(String alipayAccount) {
        return HbaseKeyEnum.K008.toString() + alipayAccount;
    }

    @Override
    public AnticheatSwitchEnum getServerNum() {
        return AnticheatSwitchEnum.ALIPAY_ACCOUNT;
    }
}

