/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.service.tongdun.FraudApiResponse;
import cn.com.duiba.anticheat.center.biz.service.tongdun.TongdunClient;
import cn.com.duiba.anticheat.center.biz.service.tongdun.TongdunThreadLocal;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatStrategyConfigService;
import cn.com.duiba.api.enums.GoodsTypeEnum;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatTongDunHighStrategy
implements AnticheatStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnticheatTongDunHighStrategy.class);
    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;
    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;

    @Override
    public int getEffectMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("tongdun-high").getEffectMode();
    }

    @Override
    public int getCheckMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("tongdun-high").getCheckMode();
    }

    @Override
    public boolean isEnable() {
        return this.anticheatStrategyConfigService.getCacheConfig("tongdun-high").getEnable();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = this.anticheatStrategyConfigService.getCacheAppConfig("tongdun-high");
        return map.containsKey(appId);
    }

    @Override
    public AnticheatStrategy.AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        if ("not_login".equals(consumer.getPartnerUserId())) {
            return new AnticheatStrategy.AnticheatStrategyResult(false);
        }
        try {
            FraudApiResponse response = TongdunThreadLocal.get().getApiResponse();
            if (response == null) {
                return new AnticheatStrategy.AnticheatStrategyResult(false);
            }
            if (TongdunClient.isReject(response)) {
                Long debugId = this.doMatchProcess(response, consumer, goods, request);
                return new AnticheatStrategy.AnticheatStrategyResult(true, debugId);
            }
            return new AnticheatStrategy.AnticheatStrategyResult(false);
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u76fe\u6821\u9a8c\u5f02\u5e38,", (Throwable)e);
            return new AnticheatStrategy.AnticheatStrategyResult(false);
        }
    }

    private Long doMatchProcess(FraudApiResponse response, ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        String message = String.format("\u6b64\u8d26\u53f7\u5728\u5151\u6362(gtype: %s, gid: %s)\u5546\u54c1\u65f6\uff0c\u540c\u76fe\u8bc4\u4f30\u98ce\u9669\u7ed3\u679c\u4e3a\u9ad8\uff0c\u540c\u76fe\u6d41\u6c34\u53f7\uff1a%s", GoodsTypeEnum.getGoodsTypeEnum((int)goods.getGtype()).getDesc(), goods.getGid(), response.getSeqId());
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType("tongdun-high");
        debug.setMessage(message);
        this.anticheatDebugLogDao.insert(debug);
        return debug.getId();
    }
}

