package cn.com.duiba.anticheat.center.biz.RedisListener;

import com.alibaba.fastjson.JSONObject;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Component;

import cn.com.duiba.anticheat.center.api.result.rules.RuleChangeDto;
import cn.com.duiba.anticheat.center.biz.service.rules.impl.KieComponent;

/**
 * Created by sty on 2018/8/1.
 */
@Component
public class RedisMessageListener implements MessageListener {

  private static final Logger LOGGER = LoggerFactory.getLogger(RedisMessageListener.class);
  @Autowired
  private StringRedisTemplate stringRedisTemplate;
  @Autowired
  private KieComponent kieComponent;


  @Override
  public void onMessage(Message message, byte[] pattern) {
    RedisSerializer<String> serializer = (RedisSerializer<String>) stringRedisTemplate.getValueSerializer();
    String transferBody = serializer.deserialize(message.getBody());
    if(StringUtils.isBlank(transferBody)){
      return;
    }

    RuleChangeDto dto;
    try{
      dto  = JSONObject.parseObject(transferBody, RuleChangeDto.class);
    }catch(Exception e){
      LOGGER.error("redis接收消息出错",e);
      return;
    }

    if(dto == null || StringUtils.isBlank(dto.getOpType()) || dto.getScene() == null){
      return;
    }

    kieComponent.changeRule(dto.getOpType(), dto.getScene(), dto.getRuleName(), dto.getRuleContent());
  }
}
