package cn.com.duiba.anticheat.center.biz.dao.rules.impl;

import com.google.common.collect.Maps;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

import cn.com.duiba.anticheat.center.biz.dao.BaseAnticheatDao;
import cn.com.duiba.anticheat.center.biz.dao.rules.RuleConfigDao;
import cn.com.duiba.anticheat.center.biz.entity.rules.RuleConfigEntity;

/**
 * Created by sty on 2018/7/24.
 */
@Repository
public class RuleConfigDaoImpl extends BaseAnticheatDao implements RuleConfigDao {

  @Override
  public RuleConfigEntity insert(RuleConfigEntity entity) {
    insert("insert", entity);
    return entity;
  }

  @Override
  public int update(RuleConfigEntity entity) {
    return update("update", entity);
  }

  @Override
  public List<RuleConfigEntity> getRuleByScene(Integer scene) {
    return selectList("findBySceneOn", scene);
  }

  @Override
  public List<RuleConfigEntity> getAllRule() {
    return selectList("findByOn");
  }

  @Override
  public int updateRuleByName(String ruleName,Integer status) {
     Map<String,Object> params = Maps.newHashMap();
     params.put("ruleName", ruleName);
     params.put("ruleStatus", status);
     return update("updateRuleByName",params);
  }

  @Override
  public RuleConfigEntity getByRuleName(String ruleName) {
    if (StringUtils.isEmpty(ruleName)) {
      return null;
    }
    return selectOne("selectByRuleName", ruleName);
  }
}
