package cn.com.duiba.anticheat.center.biz.entity.goods;

import java.util.*;

public class AnticheatStrategyConfigEntity {

    public static final String TYPE_WHITE_APP = "white-app";//app白名单策略
    public static final String TYPE_WHITE_IP = "white-ip";
    public static final String TYPE_WHITE_ITEM = "white-item";

    public static final String TYPE_BLACK_IP = "black-ip";
    public static final String TYPE_SAME_CREDITS = "same-credits";
    public static final String TYPE_SAME_DEAP = "same-deap";
    public static final String TYPE_IP_DAY_TIMES = "ip-day-times";
    public static final String TYPE_CONSUMER_DAY_TIMES = "consumer-day-times";
    public static final String TYPE_SWIPE_SKIP = "swipe-skip";
    public static final String TYPE_FIRST_IN_TIMES = "first-in-times";
    public static final String TYPE_FIRST_NO_SWIPE = "first-no-swipe";
    public static final String TYPE_SAME_CREDITS_ADD_UP = "same-credits-add-up";
    public static final String TYPE_SAME_IP = "same-ip";
    public static final String TYPE_BLACK_CONSUMER = "black-consumer";
    public static final String TYPE_FIRST_SAME_UA_CREDITS = "first-same-ua-credits";
    public static final String TYPE_TONG_DUN_HIGH = "tongdun-high"; //同盾高
    public static final String TYPE_TONG_DUN_MIDDLE = "tongdun-middle"; //同盾高



    public static final int CHECK_MODE_DEFAULT = 0;    // 默认
    public static final int CHECK_MODE_NEED_IDENTIFYING_CODE = 1;    // 需要验证码

    public static final int EFFECT_MODE_APP_BLACK_LIST = 0;// app黑名单模式(默认) 准确的说是只有指定的APP才适用本策略
    public static final int EFFECT_MODE_WHOLE = 1;    // 全局模式

    public static List<String> getAllTypes() {
        return Arrays.asList(TYPE_WHITE_ITEM, TYPE_WHITE_IP, TYPE_BLACK_IP, TYPE_SAME_CREDITS, TYPE_SAME_DEAP, TYPE_IP_DAY_TIMES, TYPE_CONSUMER_DAY_TIMES, TYPE_SWIPE_SKIP,
                TYPE_FIRST_IN_TIMES, TYPE_FIRST_NO_SWIPE, TYPE_SAME_CREDITS_ADD_UP, TYPE_SAME_IP, TYPE_BLACK_CONSUMER, TYPE_FIRST_SAME_UA_CREDITS, TYPE_TONG_DUN_HIGH, TYPE_TONG_DUN_MIDDLE, TYPE_WHITE_APP);
    }

    public static Map<String, String> getAllTypeName() {
        Map<String, String> map = new HashMap<>();
        map.put(TYPE_WHITE_IP, "IP白名单");
        map.put(TYPE_WHITE_ITEM, "兑换项白名单");
        map.put(TYPE_BLACK_IP, "IP黑名单");
        map.put(TYPE_SAME_CREDITS, "相同积分连续兑换");
        map.put(TYPE_SAME_DEAP, "相同设备切换用户兑换");
        map.put(TYPE_IP_DAY_TIMES, "相同ip一天兑换超过5次");
        map.put(TYPE_CONSUMER_DAY_TIMES, "相同用户一天兑换超过6次");
        map.put(TYPE_SWIPE_SKIP, "无需验证手势(使用非 iphone ipad android兑换)");
        map.put(TYPE_FIRST_IN_TIMES, "用户第一笔兑换在指定时间段");
        map.put(TYPE_FIRST_NO_SWIPE, "用户第一笔兑换,没有手势");
        map.put(TYPE_SAME_CREDITS_ADD_UP, "同一app，同一item，相同积分当天累计超过5次");
        map.put(TYPE_SAME_IP, "同一app，同一item，相同ip当天累计超过5次");
        map.put(TYPE_BLACK_CONSUMER, "黑名单用户");
        map.put(TYPE_FIRST_SAME_UA_CREDITS, "首次兑换，相同积分，相同UA，同一app，同一item，最近20笔兑换中，超过4笔兑换");
        map.put(TYPE_TONG_DUN_HIGH, "同盾返回评测结果高");
        map.put(TYPE_TONG_DUN_MIDDLE, "同盾返回评测结果中");
        map.put(TYPE_WHITE_APP,"APP白名单");
        return map;
    }

    private Long id;
    private String type;        // 策略类型
    private Boolean enable;        // 是否启用
    private Date gmtCreate;
    private Date gmtModified;
    private Integer checkMode;    // 拦截方式
    private Integer effectMode;    // 生效范围

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Boolean getEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getCheckMode() {
        return checkMode;
    }

    public void setCheckMode(Integer checkMode) {
        this.checkMode = checkMode;
    }

    public Integer getEffectMode() {
        return effectMode;
    }

    public void setEffectMode(Integer effectMode) {
        this.effectMode = effectMode;
    }

}
