package cn.com.duiba.anticheat.center.biz.log;

import cn.com.duiba.anticheat.center.biz.model.TongdunLogParam;
import cn.com.duiba.anticheat.center.biz.service.tongdun.FraudApiResponse;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Date;
import java.util.Map;

/**
 * 同盾打日志
 * Created by gyf .
 * 2016/11/7 .
 */
public class TongdunLog {

    private static Logger logger = LoggerFactory.getLogger(TongdunLog.class);

    private TongdunLog(){
        //隐藏静态类构造方法
    }

    /**
     * 打印tongdun结果日志
     */
    public static void log(TongdunLogParam param) {
        try {
            if (param.getFraudApiResponse() == null) {
                return;
            }
            if(logger.isInfoEnabled()) {
                logger.info(logFormat(param));
            }
        } catch (Exception e) {
            logger.error("TongdunLog 失败", e);
        }
    }

    private static String logFormat(TongdunLogParam param) {
        FraudApiResponse fraudApiResponse = param.getFraudApiResponse();

        JSONObject object = new JSONObject();
        Map<String, String> geoipInfo = fraudApiResponse.getGeoipInfo();
        Map<String, Object> deviceInfo = fraudApiResponse.getDeviceInfo();
        object.put("consumer_id", param.getConsumerId());
        object.put("app_id", param.getAppId());
        object.put("operating_activity_id", param.getOperatingActivityId());
        object.put("activity_type", param.getActivityType());
        object.put("g_id", param.getGid());
        object.put("g_type", param.getGtype());
        object.put("ip", param.getIp());
        object.put("ua", param.getUa());
        object.put("event_id", param.getEventId());
        object.put("session_id", param.getSessionId());
        object.put("final_score", fraudApiResponse.getFinalScore());
        object.put("final_decision", fraudApiResponse.getFinalDecision());
        object.put("policy_name", fraudApiResponse.getPolicyName());
        object.put("hit_rules", fraudApiResponse.getHitRules());
        object.put("seq_id", fraudApiResponse.getSeqId());
        object.put("spend_time", fraudApiResponse.getSpendTime());
        object.put("city", geoipInfo.get("city"));
        object.put("province", geoipInfo.get("province"));
        object.put("deviceType", deviceInfo.get("deviceType"));
        object.put("deviceId", deviceInfo.get("deviceId"));
        object.put("tonkenId", deviceInfo.get("tonkenId"));
        object.put("smartId", deviceInfo.get("smartId"));
        object.put("canvas", deviceInfo.get("canvas"));
        object.put("start_time", param.getStartTime());
        object.put("reply_time", param.getReplyTime());
        object.put("logTime", DateUtils.getSecondStr(new Date()));
        return object.toJSONString();
    }

}
