package cn.com.duiba.anticheat.center.biz.remoteservice.risk.impl;

import cn.com.duiba.anticheat.center.api.dto.RiskRouteDto;
import cn.com.duiba.anticheat.center.api.param.RiskRouteParam;
import cn.com.duiba.anticheat.center.api.remoteservice.risk.RemoteRiskRouteService;
import cn.com.duiba.anticheat.center.biz.service.risk.RiskRouteService;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;


/**
 * @author JunAngLiu
 * @Title: RemoteRiskRouteServiceImpl
 * @Description:
 * @date 2019/9/714:25
 */
@RestController
public class RemoteRiskRouteServiceImpl implements RemoteRiskRouteService {


    @Autowired
    private RiskRouteService riskRouteService;


    @Override
    public boolean insert(RiskRouteDto dto) throws BizException {

        return riskRouteService.insert(dto);

    }

    @Override
    public boolean updateById(RiskRouteDto dto) throws BizException{

        return riskRouteService.updateById(dto);
    }

    @Override
    public Page<RiskRouteDto> getPage(RiskRouteParam param) {
        Page<RiskRouteDto> page = new Page<>();
        if(param == null){
            return null;
        }
        int total = riskRouteService.countByParam(param);
        page.setTotalCount(total);
        if(total == 0){
            return page;
        }
        if(param.getPageNo() == null){
            page.setPageNo(1);
        }
        if(param.getPageSize() == null){
            page.setPageSize(10);
        }
        page.setList(riskRouteService.getListByParam(param));
        return page;
    }






}
