package cn.com.duiba.anticheat.center.biz.remoteservice.risk.impl;

import cn.com.duiba.anticheat.center.api.dto.RiskRouteDto;
import cn.com.duiba.anticheat.center.api.dto.RiskRuleEngineResultDto;
import cn.com.duiba.anticheat.center.api.enums.ActRiskSenceEnum;
import cn.com.duiba.anticheat.center.api.enums.RiskDecisionEnum;
import cn.com.duiba.anticheat.center.api.enums.RiskPunishWayEnum;
import cn.com.duiba.anticheat.center.api.param.RiksWhitelistMatchingParam;
import cn.com.duiba.anticheat.center.api.param.RiskRuleEngineParam;
import cn.com.duiba.anticheat.center.api.param.RiskRuleParam;
import cn.com.duiba.anticheat.center.api.param.RouteMatchingParam;
import cn.com.duiba.anticheat.center.api.remoteservice.risk.RemoteRiskRuleEngineService;
import cn.com.duiba.anticheat.center.biz.config.RiskActivityJoinConfig;
import cn.com.duiba.anticheat.center.biz.service.risk.RiskBlackListService;
import cn.com.duiba.anticheat.center.biz.service.risk.RiskRouteService;
import cn.com.duiba.anticheat.center.biz.service.risk.RiskRuleEngineService;
import cn.com.duiba.anticheat.center.biz.service.risk.RiskWhiteListService;
import cn.com.duiba.anticheat.center.common.exceptions.AnticheatException;
import cn.com.duiba.boot.exception.BizException;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * Created by fangdong on 2019/01/18
 */
@RestController
public class RemoteRiskRuleEngineServiceImpl implements RemoteRiskRuleEngineService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteRiskRuleEngineServiceImpl.class);

    @Resource
    private RiskRuleEngineService riskRuleEngineService;
    @Autowired
    private RiskActivityJoinConfig riskActivityJoinConfig;
    @Autowired
    private RiskWhiteListService riskWhiteListService;
    @Autowired
    private RiskRouteService riskRouteService;
    @Autowired
    private RiskBlackListService riskBlackListService;


    @Override
    public RiskRuleEngineResultDto operator(RiskRuleParam param) throws BizException {
        try {
            return riskRuleEngineService.execute(param);
        } catch (AnticheatException e) {
            LOGGER.warn("风控规则引擎执行接口异常, param={}", param, e);
            throw new BizException(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("风控规则引擎执行接口错误, param={}", param, e);
            throw e;
        }
    }



    @Override
    public RiskRuleEngineResultDto execute(RiskRuleEngineParam param) throws BizException {
        try {
            //参数判断
            if(param == null || StringUtils.isBlank(param.getUa())){
                RiskRuleEngineResultDto result = new RiskRuleEngineResultDto();
                result.setDecision(RiskDecisionEnum.ACCEPT);
                LOGGER.info("风控参数为空，或者ua为空");
                return result;
            }
            // 初始化返回值为 通过
            RiskRuleEngineResultDto result = new RiskRuleEngineResultDto();
            result.setDecision(RiskDecisionEnum.ACCEPT);
            //1 全局开关
            Boolean openSwitch = riskActivityJoinConfig.getOpenSwitch();
            if(BooleanUtils.isFalse(openSwitch)){
                return result;
            }
            //2 白名单验证
            RiksWhitelistMatchingParam riksWhitelistMatchingParam = new RiksWhitelistMatchingParam();
            riksWhitelistMatchingParam.setAppId(param.getAppId());
            riksWhitelistMatchingParam.setConsumerId(param.getConsumerId());
            riksWhitelistMatchingParam.setIp(param.getIp());
            riksWhitelistMatchingParam.setRiskSence(param.getScene());
            Boolean hitWhite = riskWhiteListService.riskWhitelistMatching(riksWhitelistMatchingParam);
            if(BooleanUtils.isTrue(hitWhite)){
                return result;
            }
            //3 禁止异常邮箱后缀支付宝账号提现
            if(validateAlipayAccount(param, result)) {
                return result;
            }
            //4 验证黑名单
            Boolean isBlack = riskBlackListService.riskBlacklistMatching(param.getAppId(),param.getScene().getValue(),param.getIp(),param.getConsumerId());
            if(BooleanUtils.isTrue(isBlack)){
                result.setCopy("网络错误");
                result.setDecision(RiskDecisionEnum.REJECT);
                result.setPunish(RiskPunishWayEnum.INTERRUPT_AND_POINT_OUT);
                return result;
            }
            //兑换场景不走推啊风控
            if(ObjectUtils.equals(param.getScene().getValue(),ActRiskSenceEnum.EXCHANGE.getValue())){
                return result;
            }
            //5 风控路由
            RiskRouteDto riskRouteDto = riskRouteService.routeMatch(this.convertToRouteParam(param));
            if(Objects.isNull(riskRouteDto)){
                LOGGER.warn("当前活动路由未配置,参数={}", param);
                return result;
            }

            //6 调用推啊风控接口
            result = riskRuleEngineService.executeByRoute(param,riskRouteDto.getSceneIdentity());
            result.setCopy(riskRouteDto.getCopy());
            result.setPunish(RiskPunishWayEnum.getEnumByValue(riskRouteDto.getPunishWay()));
            return result;
        } catch (AnticheatException e) {
            LOGGER.warn("风控规则引擎执行接口异常, param={}", param, e);
            throw new BizException(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("风控规则引擎执行接口错误, param={}", param, e);
            throw e;
        }
    }

    private boolean validateAlipayAccount(RiskRuleEngineParam param, RiskRuleEngineResultDto result) {
        if(BooleanUtils.isTrue(riskActivityJoinConfig.getAlipayWhiteOpenSwitch()) && StringUtils.isNotBlank(param.getAliPayAccount())){
            if(param.getAliPayAccount().indexOf("@") > -1){
                String[] suffix = StringUtils.split(param.getAliPayAccount(), '@');
                if(suffix.length != 2 || !riskActivityJoinConfig.getAlipayWhiteAccountList().contains(suffix[1])){
                    LOGGER.info("风控拦截,参数={},支付宝账号不对", JSONObject.toJSONString(param));
                    result.setDecision(RiskDecisionEnum.REJECT);
                    result.setCopy("请使用常用邮箱账号提现");
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * 路由参数转换
     * @param param
     * @return
     */
    private RouteMatchingParam convertToRouteParam(RiskRuleEngineParam param){
        RouteMatchingParam matchingParam = new RouteMatchingParam();
        matchingParam.setActivityType(param.getActivityType());
        matchingParam.setBizEnum(param.getBizEnum());
        matchingParam.setLabel(param.getLabel());
        matchingParam.setProjectId(param.getProjectId());
        matchingParam.setSenceEnum(param.getScene());
        return matchingParam;
    }

}
