package cn.com.duiba.anticheat.center.biz.service.activity.impl;

import cn.com.duiba.anticheat.center.api.dto.RiskBlackListDto;
import cn.com.duiba.anticheat.center.api.param.ActivityBlackListParam;
import cn.com.duiba.anticheat.center.biz.service.activity.ActivityBlackListService;
import cn.com.duiba.anticheat.center.common.constants.DBConstants;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.api.bo.reqresult.Result;
import cn.com.duiba.api.bo.reqresult.ResultBuilder;
import cn.com.duiba.boot.exception.BizException;
import cn.hutool.core.lang.Validator;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

import cn.com.duiba.anticheat.center.biz.dao.activity.ActivityBlackListDao;

import java.util.List;
import java.util.Objects;

import cn.com.duiba.anticheat.center.api.dto.ActivityBlackListDto;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class ActivityBlackListServiceImpl implements ActivityBlackListService {

    @Resource
    private ActivityBlackListDao activityBlackListDao;

    @Override
    public int deleteByPrimaryKey(Long id) {
        return activityBlackListDao.deleteByPrimaryKey(id);
    }

    @Override
    public Long insert(ActivityBlackListDto record) throws BizException {
        if (null == record || null == record.getAppId() || null == record.getCustomerId() || null == record.getProjectId()
                || StringUtils.isBlank(record.getIp()) || StringUtils.isBlank(record.getUa()) || null == record.getDevicedId()
                || null == record.getBannedSign() || StringUtils.isBlank(record.getBannedDescription())) {
            throw new BizException("必填参数不能为空");
        }
        if (!(Validator.isIpv4(record.getIp()) || Validator.isIpv6(record.getIp()))) {
            throw new BizException("ip格式不正确");
        }
        ActivityBlackListDto old = activityBlackListDao.findByCustomerId(record.getCustomerId());
        if (null == old) {
            activityBlackListDao.insert(record);
        } else if (old.getIsDel()) {
            record.setIsDel(false);
            record.setId(old.getId());
            activityBlackListDao.updateByPrimaryKey(record);
        } else {
            throw new BizException("当前用户已在黑名单内");
        }
        return record.getId();
    }

    @Override
    public ActivityBlackListDto selectByPrimaryKey(Long id) {
        return activityBlackListDao.selectByPrimaryKey(id);
    }


    @Override
    public int updateByPrimaryKey(ActivityBlackListDto record) {
        return activityBlackListDao.updateByPrimaryKey(record);
    }

    @Override
    public Page<ActivityBlackListDto> listByPage(ActivityBlackListParam activityBlackListParam) {
        List<ActivityBlackListDto> list = activityBlackListDao.listByCondition(activityBlackListParam);
        Integer count = activityBlackListDao.selectCountByCondition(activityBlackListParam);
        Page<ActivityBlackListDto> dtoPage = new Page<>();
        dtoPage.setTotalCount(count);
        dtoPage.setList(list);
        return dtoPage;
    }

    @Override
    public Boolean findByCustomerId(Long customerId) throws BizException {
        if (null == customerId) {
            throw new BizException("customerId不能为空");
        }
        Boolean res = true;
        ActivityBlackListDto old = activityBlackListDao.findByCustomerId(customerId);
        if (old == null || old.getIsDel()) {
            res = false;
        }
        return res;

    }

    @Override
    public Long deleteByCustomerId(Long customerId) throws BizException {
        if (null == customerId) {
            throw new BizException("customerId不能为空");
        }
        ActivityBlackListDto old = activityBlackListDao.findByCustomerId(customerId);
        if (old == null || old.getIsDel()) {
            throw new BizException("用户不在黑名单中");
        }
        activityBlackListDao.deleteByPrimaryKey(old.getId());
        return old.getId();
    }


}
