package cn.com.duiba.anticheat.center.biz.service.rules;


import cn.com.duiba.anticheat.center.api.enums.RuleSceneEnum;
import cn.com.duiba.boot.exception.BizException;

/**
 * Created by sty on 2018/7/25.
 */
public interface RuleChangeService {

  /**
   * 删除规则
   * @param scene
   * @param ruleName
   */
  void delete(RuleSceneEnum scene, String ruleName) throws BizException;

  /**
   * 增加规则
   * @param scene
   * @param ruleContent
   * @param ruleName
   */
  void add(RuleSceneEnum scene, String ruleContent, String ruleName) throws BizException;

  /**
   * 更新规则
   * @param scene
   * @param ruleContent
   * @param ruleName
   */
  void update(RuleSceneEnum scene, String ruleContent, String ruleName) throws BizException;

  /**
   * 刷新规则
   * @param scene
   * @return
   */
  Boolean refresh(RuleSceneEnum scene);

  /**
   * 打开规则
   * @param scene
   * @param ruleName
   * @return
   */
  Boolean open(RuleSceneEnum scene, String ruleName);
}
