package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.enums.HbaseKeyEnum;
import cn.com.duiba.anticheat.center.biz.service.hbase.DuibaHbaseRiskService;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;

/**
 * 一个支付宝账号的统计
 * Created by sty on 2018/8/22.
 */
@Service
public class AlipayAccountHandller implements DataServerHandler {

  @Autowired
  private DuibaHbaseRiskService duibaHbaseRiskService;
  @Autowired
  private SwitchService switchService;

  @PostConstruct
  public void init(){
    DataServerHandlerManager.registerHandler(this);
  }

  @Override
  public <T extends DuibaBaseModel> void countService(T model) {
    //不实现该方法
  }

  @Override
  public Long getService(DuibaActivityModel model) {
    return 0L;
  }

  @Override
  public Long setAndGetService(DuibaActivityModel model) {
    if(model == null){
      return 0L;
    }

    String alipayAccount = model.getAlipayAccount();

    if(!switchService.getIsOpen(AnticheatSwitchEnum.ALIPAY_ACCOUNT) || StringUtils.isEmpty(alipayAccount) ){
      return 0L;
    }

    String userKey = hbaseKey(alipayAccount);
    return duibaHbaseRiskService.increaseByKey(userKey,1L);
  }


  private String hbaseKey(String alipayAccount){
    return HbaseKeyEnum.K008.toString() + alipayAccount;
  }
  @Override
  public AnticheatSwitchEnum getServerNum() {
    return AnticheatSwitchEnum.ALIPAY_ACCOUNT;
  }
}
