package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.biz.constant.StatisticsConstant;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.enums.HbaseKeyEnum;
import cn.com.duiba.anticheat.center.biz.service.hbase.DuibaHbaseRiskService;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;

/**
 * 2.1活动期间内用户的ip数量
 * Created by sty on 2018/8/22.
 */
@Service
public class UserIpHandler implements DataServerHandler {


  @Autowired
  private SwitchService switchService;
  @Autowired
  private DuibaHbaseRiskService duibaHbaseRiskService;


  @PostConstruct
  public void init(){
    DataServerHandlerManager.registerHandler(this);
  }

  @Override
  public <T extends DuibaBaseModel> void countService(T model) {
    // This implementation is empty.
  }

  @Override
  public Long getService(DuibaActivityModel model) {
    return 0L;
  }

  @Override
  public Long setAndGetService(DuibaActivityModel model) {
    if(model == null){
      return 0L;
    }

    Long consumerId = model.getConsumerId();
    Long appId = model.getAppId();
    Long activityId = model.getActivityId();
    String ip = model.getIp();

    if(!switchService.getIsOpen(AnticheatSwitchEnum.USER_IP) ||consumerId == null || appId == null || activityId == null || StringUtils
        .isBlank(ip)){
      //数据出错无法统计
      return 0L;
    }
    String hbaseIpKey = getUserIpHbaseKey(appId, activityId, consumerId, ip);
    Long userHasIp = duibaHbaseRiskService.findByRowKey(hbaseIpKey);

    String hbaseNumKey = getUserIpHbaseKey(appId, activityId, consumerId, StatisticsConstant.USER_IP_NUM);

    if(userHasIp == null){
      duibaHbaseRiskService.upsert(hbaseIpKey, 1L);
      return duibaHbaseRiskService.increaseByKey(hbaseNumKey, 1L);
    }

    return duibaHbaseRiskService.findByRowKey(hbaseNumKey);
  }

  private String getUserIpHbaseKey(Long appId, Long activityId, long consumerId, String key) {
    return HbaseKeyEnum.K003.toString() + appId + "_" + activityId + "_" + consumerId + "_" + key;
  }
  @Override
  public AnticheatSwitchEnum getServerNum() {
    return AnticheatSwitchEnum.USER_IP;
  }
}
