package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.CacheExchangeEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.wolf.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Component
public class AnticheatSameDeapStrategy implements AnticheatStrategy {

    private static final Logger LOGGER = LoggerFactory.getLogger(AnticheatSameDeapStrategy.class);

    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;

    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;

    @Resource
    private RedisTemplate redisTemplate;

    private final String NAMESPACE = "anticheat";

    @Override
    public boolean isEnable() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_SAME_DEAP).getEnable();
    }

    @Override
    public int getCheckMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_SAME_DEAP).getCheckMode();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public int getEffectMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_SAME_DEAP).getEffectMode();
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = anticheatStrategyConfigService.getCacheAppConfig(
                AnticheatStrategyConfigEntity.TYPE_SAME_DEAP);
        return map.containsKey(appId);
    }

    /**
     * 记录同一设备切换用户兑换行为到缓存中
     */
    private void insertExchange(String cacheKey, boolean status, ConsumerParams consumer, RequestParams request) {
        try {
            CacheExchangeEntity ce = new CacheExchangeEntity();
            ce.setConsumerId(consumer.getConsumerId());
            ce.setAppId(consumer.getAppId());
            ce.setStatus(status ? 0 : 1);
            ce.setIp(request.getIp());
            ce.setUa(request.getUserAgent());
            ce.setGmtCreate(System.currentTimeMillis());
            ce.setPersistent(false);
            Long size = redisTemplate.opsForList().rightPush(cacheKey, ce);
            if(size != null && size == 1L) {
                redisTemplate.expire(cacheKey, DateUtils.getToTomorrowSeconds(), TimeUnit.SECONDS);
            }
        } catch (Exception e) {
            LOGGER.error("记录同一设备切换用户兑换行为到缓存异常", e);
        }
    }

    @Override
    public AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods,
                                                       RequestParams request, BehaviorParams behavior) {
        String deviceNumber = request.getDeap();
        Integer limitCount = goods.getLimitCount();
        // 如果设备号为空，则不做限制
        if (deviceNumber == null) {
            return new AnticheatStrategyResult(false);
        }
        // 如果兑换次数为空，则不再做限制
        if (limitCount == null) {
            return new AnticheatStrategyResult(false);
        }
        Integer gtype = goods.getGtype();
        Long gid = goods.getGid();
        Long appId = consumer.getAppId();
        String cachekey = String.format("%s-%s-appId-%s-gtype-%s-gid-%s", NAMESPACE, deviceNumber, appId, gtype, gid);
        Long exchangeSize = redisTemplate.opsForList().size(cachekey);
        if (exchangeSize != null) {
            if (exchangeSize >= limitCount) {
                // 记录命中日志
                Long debugId = doMatchProcess(consumer, goods, request);
                return new AnticheatStrategyResult(true, debugId);
            } else {
                // 记录兑换行为（正常）
                insertExchange(cachekey, true, consumer, request);
            }
        } else {
            // 记录兑换行为（正常）
            insertExchange(cachekey, true, consumer, request);
        }

        return new AnticheatStrategyResult(false);
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType(AnticheatStrategyConfigEntity.TYPE_SAME_DEAP);
        debug.setMessage(String.format("相同设备号: %s, 切换帐号总共兑换达到limitCount: %s 次", request.getDeap(),
                goods.getLimitCount()));

        anticheatDebugLogDao.insert(debug);

        return debug.getId();
    }

}
