package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatIpLimitDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatIpLimitEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * IP白名单策略
 *
 * @author xuhengfei
 */
@Component
public class AnticheatWhiteIpStrategy implements AnticheatStrategy {
    @Autowired
    private AnticheatIpLimitDao            anticheatIpLimitDao;
    @Autowired
    private AnticheatDebugLogDao           anticheatDebugLogDao;
    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;

    public List<AnticheatIpLimitEntity> getList() {
        return anticheatIpLimitDao.findAllWhiteList();
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = anticheatStrategyConfigService
                .getCacheAppConfig(AnticheatStrategyConfigEntity.TYPE_WHITE_IP);
        return map.containsKey(appId);
    }

    @Override
    public int getCheckMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_WHITE_IP).getCheckMode();
    }

    @Override
    public int getEffectMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_WHITE_IP).getEffectMode();
    }

    @Override
    public boolean isEnable() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_WHITE_IP).getEnable();
    }

    /**
     * 判断是否在白名单中
     *
     * @param ip
     * @return
     */
    public AnticheatIpLimitEntity checkInWhiteList(String ip) {
        if (StringUtils.isNotBlank(ip)) {
            AnticheatIpLimitEntity record = anticheatIpLimitDao.findEnableWhiteIp(ip);
            if (record != null) {
                return record;
            }
            //IP网段查询
            String regionip = ip.substring(0, ip.lastIndexOf('.'));
            record = anticheatIpLimitDao.findEnableWhiteIp(regionip);
            if (record != null) {
                return record;
            }
        }
        return null;
    }


    @Override
    public AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        String ip = request.getIp();
        if (StringUtils.isNotBlank(ip)) {
            AnticheatIpLimitEntity record = checkInWhiteList(ip);
            if (record != null) {
                Long debugId = doMatchProcess(consumer, goods, request, record);
                return new AnticheatStrategyResult(true, debugId);
            }
        }
        return new AnticheatStrategyResult(false);
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request, AnticheatIpLimitEntity record) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType(AnticheatStrategyConfigEntity.TYPE_WHITE_IP);
        debug.setMessage(String.format("此IP在IP白名单中(%s, %s)", record.getIp(), record.getRemark()));

        anticheatDebugLogDao.insert(debug);

        return debug.getId();
    }

    @Override
    public boolean isBlackMode() {
        return false;
    }

}
