package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatWhiteItemDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatWhiteItemEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.api.enums.GoodsTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 兑换项白名单
 *
 * @author zhengjy
 */
@Component
public class AnticheatWhiteItemStrategy implements AnticheatStrategy {

    @Autowired
    private AnticheatWhiteItemDao          anticheatWhiteItemDao;
    @Autowired
    private AnticheatDebugLogDao           anticheatDebugLogDao;
    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = anticheatStrategyConfigService
                .getCacheAppConfig(AnticheatStrategyConfigEntity.TYPE_WHITE_ITEM);
        return map.containsKey(appId);
    }

    @Override
    public int getCheckMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_WHITE_ITEM).getCheckMode();
    }

    @Override
    public int getEffectMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_WHITE_ITEM).getEffectMode();
    }

    @Override
    public boolean isEnable() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_WHITE_ITEM).getEnable();
    }

    /**
     * 判断是否在白名单中
     *
     * @param ip
     * @return
     */
    public AnticheatWhiteItemEntity checkInWhiteList(Long itemId) {
        if (itemId != null) {
            AnticheatWhiteItemEntity record = anticheatWhiteItemDao.findWhiteItemById(itemId);
            if (record != null) {
                return record;
            }
        }
        return null;
    }


    @Override
    public AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        if (GoodsTypeEnum.DUIBA.getGtype() != goods.getGtype()) {
            return new AnticheatStrategyResult(false);
        }
        Long itemId = goods.getGid();
        AnticheatWhiteItemEntity record = checkInWhiteList(itemId);
        if (record != null) {
            Long debugId = doMatchProcess(consumer, goods, request);
            return new AnticheatStrategyResult(true, debugId);
        }
        return new AnticheatStrategyResult(false);
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType(AnticheatStrategyConfigEntity.TYPE_WHITE_ITEM);
        debug.setMessage(String.format("此item在item白名单中：%s", goods.getGid()));

        anticheatDebugLogDao.insert(debug);
        return debug.getId();
    }

    @Override
    public boolean isBlackMode() {
        return false;
    }

}
