/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.RedisListener;

import cn.com.duiba.anticheat.center.api.result.rules.RuleChangeDto;
import cn.com.duiba.anticheat.center.biz.service.rules.impl.KieComponent;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Component;

@Component
public class RedisMessageListener
implements MessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisMessageListener.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private KieComponent kieComponent;

    public void onMessage(Message message, byte[] pattern) {
        RuleChangeDto dto;
        RedisSerializer serializer = this.stringRedisTemplate.getValueSerializer();
        String transferBody = (String)serializer.deserialize(message.getBody());
        if (StringUtils.isBlank((CharSequence)transferBody)) {
            return;
        }
        try {
            dto = (RuleChangeDto)JSONObject.parseObject((String)transferBody, RuleChangeDto.class);
        }
        catch (Exception e) {
            LOGGER.error("redis\u63a5\u6536\u6d88\u606f\u51fa\u9519", (Throwable)e);
            return;
        }
        if (dto == null || StringUtils.isBlank((CharSequence)dto.getOpType()) || dto.getScene() == null) {
            return;
        }
        this.kieComponent.changeRule(dto.getOpType(), dto.getScene(), dto.getRuleName(), dto.getRuleContent());
    }
}

