/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.remoteservice.risk.impl;

import cn.com.duiba.anticheat.center.api.dto.RiskRouteDto;
import cn.com.duiba.anticheat.center.api.dto.RiskRuleEngineResultDto;
import cn.com.duiba.anticheat.center.api.enums.ActRiskSenceEnum;
import cn.com.duiba.anticheat.center.api.enums.RiskDecisionEnum;
import cn.com.duiba.anticheat.center.api.enums.RiskPunishWayEnum;
import cn.com.duiba.anticheat.center.api.param.RiksWhitelistMatchingParam;
import cn.com.duiba.anticheat.center.api.param.RiskRuleEngineParam;
import cn.com.duiba.anticheat.center.api.param.RiskRuleParam;
import cn.com.duiba.anticheat.center.api.param.RouteMatchingParam;
import cn.com.duiba.anticheat.center.api.remoteservice.risk.RemoteRiskRuleEngineService;
import cn.com.duiba.anticheat.center.biz.config.RiskActivityJoinConfig;
import cn.com.duiba.anticheat.center.biz.service.risk.RiskBlackListService;
import cn.com.duiba.anticheat.center.biz.service.risk.RiskRouteService;
import cn.com.duiba.anticheat.center.biz.service.risk.RiskRuleEngineService;
import cn.com.duiba.anticheat.center.biz.service.risk.RiskWhiteListService;
import cn.com.duiba.anticheat.center.common.exceptions.AnticheatException;
import cn.com.duiba.boot.exception.BizException;
import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteRiskRuleEngineServiceImpl
implements RemoteRiskRuleEngineService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteRiskRuleEngineServiceImpl.class);
    @Resource
    private RiskRuleEngineService riskRuleEngineService;
    @Autowired
    private RiskActivityJoinConfig riskActivityJoinConfig;
    @Autowired
    private RiskWhiteListService riskWhiteListService;
    @Autowired
    private RiskRouteService riskRouteService;
    @Autowired
    private RiskBlackListService riskBlackListService;

    public RiskRuleEngineResultDto operator(RiskRuleParam param) throws BizException {
        try {
            return this.riskRuleEngineService.execute(param);
        }
        catch (AnticheatException e) {
            LOGGER.warn("\u98ce\u63a7\u89c4\u5219\u5f15\u64ce\u6267\u884c\u63a5\u53e3\u5f02\u5e38, param={}", (Object)param, (Object)e);
            throw new BizException(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u98ce\u63a7\u89c4\u5219\u5f15\u64ce\u6267\u884c\u63a5\u53e3\u9519\u8bef, param={}", (Object)param, (Object)e);
            throw e;
        }
    }

    public RiskRuleEngineResultDto execute(RiskRuleEngineParam param) throws BizException {
        try {
            if (param == null || StringUtils.isBlank((String)param.getUa())) {
                RiskRuleEngineResultDto result = new RiskRuleEngineResultDto();
                result.setDecision(RiskDecisionEnum.ACCEPT);
                LOGGER.info("\u98ce\u63a7\u53c2\u6570\u4e3a\u7a7a\uff0c\u6216\u8005ua\u4e3a\u7a7a");
                return result;
            }
            RiskRuleEngineResultDto result = new RiskRuleEngineResultDto();
            result.setDecision(RiskDecisionEnum.ACCEPT);
            Boolean openSwitch = this.riskActivityJoinConfig.getOpenSwitch();
            if (BooleanUtils.isFalse((Boolean)openSwitch)) {
                return result;
            }
            RiksWhitelistMatchingParam riksWhitelistMatchingParam = new RiksWhitelistMatchingParam();
            riksWhitelistMatchingParam.setAppId(param.getAppId());
            riksWhitelistMatchingParam.setConsumerId(param.getConsumerId());
            riksWhitelistMatchingParam.setIp(param.getIp());
            riksWhitelistMatchingParam.setRiskSence(param.getScene());
            Boolean hitWhite = this.riskWhiteListService.riskWhitelistMatching(riksWhitelistMatchingParam);
            if (BooleanUtils.isTrue((Boolean)hitWhite)) {
                return result;
            }
            if (this.validateAlipayAccount(param, result)) {
                return result;
            }
            Boolean isBlack = this.riskBlackListService.riskBlacklistMatching(param.getAppId(), param.getScene().getValue(), param.getIp(), param.getConsumerId());
            if (BooleanUtils.isTrue((Boolean)isBlack)) {
                result.setCopy("\u7f51\u7edc\u9519\u8bef");
                result.setDecision(RiskDecisionEnum.REJECT);
                result.setPunish(RiskPunishWayEnum.INTERRUPT_AND_POINT_OUT);
                return result;
            }
            if (ObjectUtils.equals((Object)param.getScene().getValue(), (Object)ActRiskSenceEnum.EXCHANGE.getValue())) {
                return result;
            }
            RiskRouteDto riskRouteDto = this.riskRouteService.routeMatch(this.convertToRouteParam(param));
            if (Objects.isNull(riskRouteDto)) {
                LOGGER.warn("\u5f53\u524d\u6d3b\u52a8\u8def\u7531\u672a\u914d\u7f6e,\u53c2\u6570={}", (Object)param);
                return result;
            }
            result = this.riskRuleEngineService.executeByRoute(param, riskRouteDto.getSceneIdentity());
            result.setCopy(riskRouteDto.getCopy());
            result.setPunish(RiskPunishWayEnum.getEnumByValue((Integer)riskRouteDto.getPunishWay()));
            return result;
        }
        catch (AnticheatException e) {
            LOGGER.warn("\u98ce\u63a7\u89c4\u5219\u5f15\u64ce\u6267\u884c\u63a5\u53e3\u5f02\u5e38, param={}", (Object)param, (Object)e);
            throw new BizException(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u98ce\u63a7\u89c4\u5219\u5f15\u64ce\u6267\u884c\u63a5\u53e3\u9519\u8bef, param={}", (Object)param, (Object)e);
            throw e;
        }
    }

    private boolean validateAlipayAccount(RiskRuleEngineParam param, RiskRuleEngineResultDto result) {
        String[] suffix;
        if (BooleanUtils.isTrue((Boolean)this.riskActivityJoinConfig.getAlipayWhiteOpenSwitch()) && StringUtils.isNotBlank((String)param.getAliPayAccount()) && param.getAliPayAccount().indexOf("@") > -1 && ((suffix = StringUtils.split((String)param.getAliPayAccount(), (char)'@')).length != 2 || !this.riskActivityJoinConfig.getAlipayWhiteAccountList().contains(suffix[1]))) {
            LOGGER.info("\u98ce\u63a7\u62e6\u622a,\u53c2\u6570={},\u652f\u4ed8\u5b9d\u8d26\u53f7\u4e0d\u5bf9", (Object)JSONObject.toJSONString((Object)param));
            result.setDecision(RiskDecisionEnum.REJECT);
            result.setCopy("\u8bf7\u4f7f\u7528\u5e38\u7528\u90ae\u7bb1\u8d26\u53f7\u63d0\u73b0");
            return true;
        }
        return false;
    }

    private RouteMatchingParam convertToRouteParam(RiskRuleEngineParam param) {
        RouteMatchingParam matchingParam = new RouteMatchingParam();
        matchingParam.setActivityType(param.getActivityType());
        matchingParam.setBizEnum(param.getBizEnum());
        matchingParam.setLabel(param.getLabel());
        matchingParam.setProjectId(param.getProjectId());
        matchingParam.setSenceEnum(param.getScene());
        return matchingParam;
    }
}

