/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.enums.HbaseKeyEnum;
import cn.com.duiba.anticheat.center.biz.service.hbase.DuibaHbaseRiskService;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;

public class AlipayAccountWithUaTimesHandler
implements DataServerHandler {
    @Resource
    private SwitchService switchService;
    @Resource
    private DuibaHbaseRiskService duibaHbaseRiskService;

    @PostConstruct
    public void init() {
        DataServerHandlerManager.registerHandler(this);
    }

    @Override
    public <T extends DuibaBaseModel> void countService(T model) {
    }

    @Override
    public Long getService(DuibaActivityModel model) {
        return 0L;
    }

    @Override
    public AnticheatSwitchEnum getServerNum() {
        return AnticheatSwitchEnum.ALIPAY_ACCOUNT_WITH_UA_TIMES;
    }

    @Override
    public Long setAndGetService(DuibaActivityModel model) {
        if (model == null) {
            return 0L;
        }
        String ua = model.getUa();
        String alipayAccount = model.getAlipayAccount();
        if (!this.switchService.getIsOpen(AnticheatSwitchEnum.ALIPAY_ACCOUNT_WITH_UA_TIMES) || StringUtils.isEmpty((CharSequence)ua) || StringUtils.isEmpty((CharSequence)alipayAccount)) {
            return 0L;
        }
        String uaKey = this.hbaseKey(alipayAccount, ua);
        String uaNumKey = this.hbaseKey(alipayAccount, "alipayAccountUaNum");
        Long accountUa = this.duibaHbaseRiskService.findByRowKey(uaKey);
        if (accountUa == null) {
            this.duibaHbaseRiskService.upsert(uaKey, 1L);
            return this.duibaHbaseRiskService.increaseByKey(uaNumKey, 1L);
        }
        return this.duibaHbaseRiskService.findByRowKey(uaNumKey);
    }

    private String hbaseKey(String alipayAccount, String key) {
        return HbaseKeyEnum.K012.toString() + alipayAccount + "_" + key;
    }
}

