/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.biz.constant.RedisKeyFactory;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.StringRedisConnection;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class MinutesIpAskHandler
implements DataServerHandler {
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private SwitchService switchService;

    @PostConstruct
    public void init() {
        DataServerHandlerManager.registerHandler(this);
    }

    @Override
    public <T extends DuibaBaseModel> void countService(T model) {
    }

    @Override
    public Long getService(DuibaActivityModel model) {
        return 0L;
    }

    @Override
    public Long setAndGetService(DuibaActivityModel model) {
        if (model == null) {
            return 0L;
        }
        Long appId = model.getAppId();
        Long activityId = model.getActivityId();
        String ip = model.getIp();
        if (!this.switchService.getIsOpen(AnticheatSwitchEnum.IP_ASK) || appId == null || activityId == null || StringUtils.isBlank((CharSequence)ip)) {
            return 0L;
        }
        String redisKey = (Object)((Object)RedisKeyFactory.K012) + ip + "_" + appId + "_" + activityId;
        List results = this.stringRedisTemplate.executePipelined(connection -> {
            StringRedisConnection conn = (StringRedisConnection)connection;
            conn.incr(redisKey);
            conn.ttl(redisKey);
            return null;
        });
        Long times = (Long)results.get(0);
        Long ttl = (Long)results.get(1);
        if (ttl == -1L) {
            this.stringRedisTemplate.expire((Object)redisKey, 1L, TimeUnit.MINUTES);
        }
        return times;
    }

    @Override
    public AnticheatSwitchEnum getServerNum() {
        return AnticheatSwitchEnum.IP_ASK;
    }
}

