/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.rules.impl;

import cn.com.duiba.anticheat.center.api.enums.RuleSceneEnum;
import cn.com.duiba.anticheat.center.biz.dao.rules.RuleConfigDao;
import cn.com.duiba.anticheat.center.biz.entity.rules.RuleConfigEntity;
import cn.com.duiba.anticheat.center.biz.service.rules.RuleLoadService;
import cn.com.duiba.anticheat.center.common.exceptions.AnticheatException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.utils.KieHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KieComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieComponent.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    @Autowired
    private RuleLoadService ruleLoadService;
    @Autowired
    private RuleConfigDao ruleConfigDao;
    private static Map<Integer, KieBase> ruleMap = new ConcurrentHashMap<Integer, KieBase>();

    @PostConstruct
    public void init() {
        System.setProperty("drools.dateformat", DATE_FORMAT);
        List<RuleConfigEntity> rules = this.ruleLoadService.getAllRule();
        HashMap ruleSceneMap = Maps.newHashMap();
        rules.forEach(one -> {
            List curList = (List)ruleSceneMap.get(one.getRuleScene());
            if (curList == null) {
                curList = Lists.newArrayList();
            }
            curList.add(one);
            ruleSceneMap.put(one.getRuleScene(), curList);
        });
        for (RuleSceneEnum ruleSingleEnum : RuleSceneEnum.values()) {
            Integer codeForRule = ruleSingleEnum.getType();
            List sceneRules = (List)ruleSceneMap.get(codeForRule);
            KieHelper helper = new KieHelper();
            if (CollectionUtils.isNotEmpty((Collection)sceneRules)) {
                sceneRules.forEach(one -> helper.addContent(one.getRuleContent(), ResourceType.DRL));
            }
            ruleMap.put(codeForRule, helper.build(new KieBaseOption[0]));
        }
    }

    public static KieBase getBaseByScene(Integer scene) {
        return ruleMap.get(scene);
    }

    public void changeRule(String opType, RuleSceneEnum scene, String ruleName, String ruleContent) {
        KnowledgeBaseImpl kbase = (KnowledgeBaseImpl)KieComponent.getBaseByScene(scene.getType());
        if (kbase == null) {
            return;
        }
        if ("delete".equals(opType)) {
            kbase.removeRule(scene.getPkg(), ruleName);
        }
        if ("add".equals(opType) && StringUtils.isNotBlank((CharSequence)ruleContent) && this.kbaseAddRule(ruleContent, kbase)) {
            return;
        }
        if ("update".equals(opType) && StringUtils.isNotBlank((CharSequence)ruleContent)) {
            this.updateKbase(scene, ruleName, ruleContent, kbase);
        }
        if ("refresh".equals(opType)) {
            this.refresh(scene);
        }
        if ("open".equals(opType)) {
            this.open(ruleName, kbase);
        }
    }

    private void open(String ruleName, KnowledgeBaseImpl kbase) {
        RuleConfigEntity rule = this.ruleConfigDao.getByRuleName(ruleName);
        if (rule == null) {
            throw new AnticheatException("\u89c4\u5219\u4e0d\u5b58\u5728, " + ruleName);
        }
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        builder.add(ResourceFactory.newByteArrayResource((byte[])rule.getRuleContent().getBytes(StandardCharsets.UTF_8)), ResourceType.DRL);
        kbase.addPackages(builder.getKnowledgePackages());
    }

    private void refresh(RuleSceneEnum scene) {
        List<RuleConfigEntity> rules = this.ruleLoadService.getAllRule();
        KieHelper helper = new KieHelper();
        for (RuleConfigEntity rule : rules) {
            if (!rule.getRuleScene().equals(scene.getType())) continue;
            helper.addContent(rule.getRuleContent(), ResourceType.DRL);
        }
        KieBase kieBase = helper.build(new KieBaseOption[0]);
        ruleMap.put(scene.getType(), kieBase);
    }

    private boolean kbaseAddRule(String ruleContent, KnowledgeBaseImpl kbase) {
        KnowledgeBuilder kb = KnowledgeBuilderFactory.newKnowledgeBuilder();
        try {
            kb.add(ResourceFactory.newByteArrayResource((byte[])ruleContent.getBytes("utf-8")), ResourceType.DRL);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u89c4\u5219\u8f6c\u4e3a\u4e8c\u8fdb\u5236\u8f6c\u6362\u51fa\u9519", (Throwable)e);
            return true;
        }
        kbase.addPackages(kb.getKnowledgePackages());
        return false;
    }

    private void updateKbase(RuleSceneEnum scene, String ruleName, String ruleContent, KnowledgeBaseImpl kbase) {
        KnowledgeBuilder kb = KnowledgeBuilderFactory.newKnowledgeBuilder();
        try {
            kb.add(ResourceFactory.newByteArrayResource((byte[])ruleContent.getBytes("utf-8")), ResourceType.DRL);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u89c4\u5219\u8f6c\u4e3a\u4e8c\u8fdb\u5236\u8f6c\u6362\u51fa\u9519", (Throwable)e);
            return;
        }
        kbase.removeRule(scene.getPkg(), ruleName);
        kbase.addPackages(kb.getKnowledgePackages());
    }
}

