/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.dao.goods.ConsumerFootprintDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.ConsumerFootprintEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.FootprintEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatStrategyConfigService;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatFirstNoSwipeStrategy
implements AnticheatStrategy {
    private static final int SWIPE_NOT_EXIST = 0;
    @Resource(name="redisTemplate")
    private RedisAtomicClient redisAtomicClient;
    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;
    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;
    @Autowired
    private ConsumerFootprintDao consumerFootprintDao;

    @Override
    public int getEffectMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("first-no-swipe").getEffectMode();
    }

    @Override
    public int getCheckMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("first-no-swipe").getCheckMode();
    }

    @Override
    public boolean isEnable() {
        return this.anticheatStrategyConfigService.getCacheConfig("first-no-swipe").getEnable();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = this.anticheatStrategyConfigService.getCacheAppConfig("first-no-swipe");
        return map.containsKey(appId);
    }

    @Override
    public AnticheatStrategy.AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        boolean ret;
        Long consumerId = consumer.getConsumerId();
        Integer swipe = behavior.getSwipe();
        Long appId = consumer.getAppId();
        Integer gtype = goods.getGtype();
        Long gid = goods.getGid();
        boolean bl = ret = Objects.equals(0, swipe) && this.isFirstExchange(consumerId);
        if (ret && this.check(appId, gtype, gid)) {
            Long debugId = this.doMatchProcess(consumer, goods, request);
            return new AnticheatStrategy.AnticheatStrategyResult(true, debugId);
        }
        return new AnticheatStrategy.AnticheatStrategyResult(false);
    }

    private boolean check(Long appId, Integer gtype, Long gid) {
        String key = this.getKey(appId, gtype, gid);
        long ecCount = this.redisAtomicClient.incrBy(key, 1L, (long)DateUtils.getToTomorrowSeconds(), TimeUnit.SECONDS);
        return ecCount >= 5L;
    }

    private boolean isFirstExchange(Long consumerId) {
        ConsumerFootprintEntity footprint = this.consumerFootprintDao.findCouponByConsumerId(consumerId);
        if (footprint == null) {
            return true;
        }
        List<FootprintEntity> fpList = footprint.getColumnDataByType("coupon");
        return fpList.isEmpty();
    }

    private String getKey(Long appId, Integer gtype, Long gid) {
        return String.format("%s-first-out-mins-appId-%s-gtype-%s-gid-%s", 103, appId, gtype, gid);
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType("first-no-swipe");
        debug.setMessage(String.format("\u6b64\u7528\u6237 id(%s),\u6ca1\u624b\u52bf\u7684\u7528\u6237\u7b2c\u4e00\u7b14\u5151\u6362", consumer.getConsumerId()));
        this.anticheatDebugLogDao.insert(debug);
        return debug.getId();
    }
}

