/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.dao.goods.ConsumerFootprintDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.ConsumerFootprintEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.FootprintEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatStrategyConfigService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatFirstSameUaCreditsStrategy
implements AnticheatStrategy {
    private static final int RANGE_VALUE = 20;
    private static final int MATCH_VALUE = 5;
    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;
    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;
    @Autowired
    private ConsumerFootprintDao consumerFootprintDao;
    private Map<String, Queue<Model>> data = new HashMap<String, Queue<Model>>();

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = this.anticheatStrategyConfigService.getCacheAppConfig("first-same-ua-credits");
        return map.containsKey(appId);
    }

    @Override
    public int getEffectMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("first-same-ua-credits").getEffectMode();
    }

    @Override
    public int getCheckMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("first-same-ua-credits").getCheckMode();
    }

    @Override
    public boolean isEnable() {
        return this.anticheatStrategyConfigService.getCacheConfig("first-same-ua-credits").getEnable();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public AnticheatStrategy.AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        boolean isFirst;
        Long credits;
        String ua;
        Long gid;
        Integer gtype;
        Long appId = consumer.getAppId();
        if (this.check(appId, gtype = goods.getGtype(), gid = goods.getGid(), ua = request.getUserAgent(), credits = consumer.getCredits(), isFirst = this.isFirstExchange(consumer.getConsumerId()))) {
            Long debugId = this.doMatchProcess(consumer, goods, request);
            return new AnticheatStrategy.AnticheatStrategyResult(true, debugId);
        }
        return new AnticheatStrategy.AnticheatStrategyResult(false);
    }

    public boolean check(Long appId, Integer gtype, Long gid, String ua, Long credits, boolean isFirst) {
        Model model = new Model();
        model.appId = appId;
        model.gtype = gtype;
        model.gid = gid;
        model.ua = ua;
        model.credits = credits;
        model.isFirst = isFirst;
        String datakey = this.getDataKey(model.appId, model.gtype, model.gid);
        Queue queue = this.data.computeIfAbsent(datakey, key -> new LinkedBlockingQueue());
        queue.offer(model);
        while (queue.size() > 20) {
            queue.poll();
        }
        int count = 0;
        for (Model aQueue : queue) {
            if (!aQueue.equalsTo(model)) continue;
            ++count;
        }
        return count > 5;
    }

    private String getDataKey(Long appId, Integer gtype, Long gid) {
        return String.format("%s-%s-%s", appId, gtype, gid);
    }

    private boolean isFirstExchange(Long consumerId) {
        ConsumerFootprintEntity footprint = this.consumerFootprintDao.findCouponByConsumerId(consumerId);
        if (footprint == null) {
            return true;
        }
        List<FootprintEntity> fpList = footprint.getColumnDataByType("coupon");
        return fpList.isEmpty();
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType("first-same-ua-credits");
        debug.setMessage(String.format("\u9996\u6b21\u5151\u6362, app=%s, gtype=%s, gid=%s, \u79ef\u5206=%s, UA=%s, \u6700\u8fd120\u7b14\u5151\u6362\u4e2d\uff0c\u8d85\u8fc74\u7b14\u9996\u6b21\u5151\u6362", consumer.getAppId(), goods.getGtype(), goods.getGid(), consumer.getCredits(), request.getUserAgent()));
        this.anticheatDebugLogDao.insert(debug);
        return debug.getId();
    }

    private class Model {
        private Long appId;
        private Integer gtype;
        private Long gid;
        private Long credits;
        private String ua;
        private boolean isFirst;

        private Model() {
        }

        public boolean equalsTo(Model obj) {
            boolean ret = false;
            if (obj.appId.equals(this.appId) && obj.gtype.equals(this.gtype) && obj.gid.equals(this.gid) && obj.credits.equals(this.credits)) {
                ret = true;
            }
            return ret && obj.ua != null && obj.ua.equals(this.ua) && obj.isFirst && this.isFirst;
        }
    }
}

