/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatIpLimitDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatIpLimitEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatStrategyConfigService;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatWhiteIpStrategy
implements AnticheatStrategy {
    @Autowired
    private AnticheatIpLimitDao anticheatIpLimitDao;
    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;
    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;

    public List<AnticheatIpLimitEntity> getList() {
        return this.anticheatIpLimitDao.findAllWhiteList();
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = this.anticheatStrategyConfigService.getCacheAppConfig("white-ip");
        return map.containsKey(appId);
    }

    @Override
    public int getCheckMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("white-ip").getCheckMode();
    }

    @Override
    public int getEffectMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("white-ip").getEffectMode();
    }

    @Override
    public boolean isEnable() {
        return this.anticheatStrategyConfigService.getCacheConfig("white-ip").getEnable();
    }

    public AnticheatIpLimitEntity checkInWhiteList(String ip) {
        if (StringUtils.isNotBlank((CharSequence)ip)) {
            AnticheatIpLimitEntity record = this.anticheatIpLimitDao.findEnableWhiteIp(ip);
            if (record != null) {
                return record;
            }
            String regionip = ip.substring(0, ip.lastIndexOf(46));
            record = this.anticheatIpLimitDao.findEnableWhiteIp(regionip);
            if (record != null) {
                return record;
            }
        }
        return null;
    }

    @Override
    public AnticheatStrategy.AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        AnticheatIpLimitEntity record;
        String ip = request.getIp();
        if (StringUtils.isNotBlank((CharSequence)ip) && (record = this.checkInWhiteList(ip)) != null) {
            Long debugId = this.doMatchProcess(consumer, goods, request, record);
            return new AnticheatStrategy.AnticheatStrategyResult(true, debugId);
        }
        return new AnticheatStrategy.AnticheatStrategyResult(false);
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request, AnticheatIpLimitEntity record) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType("white-ip");
        debug.setMessage(String.format("\u6b64IP\u5728IP\u767d\u540d\u5355\u4e2d(%s, %s)", record.getIp(), record.getRemark()));
        this.anticheatDebugLogDao.insert(debug);
        return debug.getId();
    }

    @Override
    public boolean isBlackMode() {
        return false;
    }
}

