package cn.com.duiba.anticheat.center.biz.dao;

import java.io.Serializable;

public interface BaseEntityMapper<T, PK extends Serializable> {

	/**
	 * 根据id查询
	 * 
	 * @param id
	 * @return
	 */
	public T find(final PK id);

	/**
	 * 新增记录
	 * 
	 * @param entity
	 * @return
	 */
	public void insert(final T entity);

	/**
	 * 更新记录
	 * 
	 * @param entity
	 */
	public int update(final T entity);

}
