package cn.com.duiba.anticheat.center.biz.dao.risk.impl;

import cn.com.duiba.anticheat.center.api.dto.RiskBlackListDto;
import cn.com.duiba.anticheat.center.api.param.RiskBlackListParam;
import cn.com.duiba.anticheat.center.biz.dao.BaseDao;
import cn.com.duiba.anticheat.center.biz.dao.DatabaseSchema;
import cn.com.duiba.anticheat.center.biz.dao.risk.RiskBlackListDao;
import org.springframework.stereotype.Repository;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author XuJing
 * @since 2020/3/25 2:10 下午
 */
@Repository
public class RiskBlackListDaoImpl extends BaseDao implements RiskBlackListDao {
    @PostConstruct
    private void init() {
        this.databaseSchema = DatabaseSchema.DEVELOPER_APP;
    }

    @Override
    public int deleteByPrimaryKey(Long id) {
        return delete("deleteByPrimaryKey", id);
    }

    @Override
    public int insert(RiskBlackListDto record) {
        return insert("insert", record);
    }

    @Override
    public RiskBlackListDto selectByPrimaryKey(Long id) {
        return selectOne("selectByPrimaryKey", id);
    }

    @Override
    public int updateByPrimaryKeySelective(RiskBlackListDto record) {
        return update("updateByPrimaryKeySelective", record);
    }

    @Override
    public int batchInsert(List<RiskBlackListDto> list) {
        return insert("batchInsert", list);
    }

    @Override
    public List<RiskBlackListDto> listByCondition(RiskBlackListParam riskBlackListParam) {
        return selectList("listByCondition", riskBlackListParam);
    }

    @Override
    public Integer selectCountByCondition(RiskBlackListParam riskBlackListParam) {
        return selectOne("selectCountByCondition", riskBlackListParam);
    }

    @Override
    public RiskBlackListDto findByParam(Long appId, Integer riskType, Integer riskScene, String riskValue) {
        Map<String, Object> map = new HashMap();
        map.put("appId", appId);
        map.put("riskType", riskType);
        map.put("riskScene", riskScene);
        map.put("riskValue", riskValue);
        return selectOne("findByParam", map);
    }

    @Override
    public List<String> listByAppIdAndRiskScene(Long appId, Integer riskScene) {
        Map<String, Object> map = new HashMap();
        map.put("appId", appId);
        map.put("riskScene", riskScene);
        return selectList("listByAppIdAndRiskScene", map);
    }
}
