package cn.com.duiba.anticheat.center.biz.entity.goods;

import cn.com.duiba.wolf.utils.DateUtils;

import java.util.Date;

public class AnticheatBlackConsumerEntity extends BaseEntity {

    public static final int ANTICHEAT_ANALYSE = 1;
    public static final int ANTICHEAT_DEFAULT = 0;
    public static final int DEFAULT = 2;
    public static final int REJECT = 1;
    public static final int CAPTCHA = 2;

    private Long id;

    private Long consumerId;

    private Date gmtCreate;

    private Integer sourceType;

    private Date expirationDate;

    private Date gmtModified;

    private Integer rejectStrategy;

    private String reason;


    public AnticheatBlackConsumerEntity() {
    }

    public AnticheatBlackConsumerEntity(Long id) {
        this.id = id;
        this.gmtModified = new Date();
        toBeUpdate = true;
    }

    public AnticheatBlackConsumerEntity(boolean init4insert, int sourceType) {
        if (init4insert) {
            toBeInsert = true;
            gmtCreate = new Date();
            gmtModified = new Date();
        }
        if (ANTICHEAT_ANALYSE == sourceType) {
            sourceType = ANTICHEAT_ANALYSE;
            expirationDate = DateUtils.getDayDate("2035-01-01");
        } else {
            sourceType = ANTICHEAT_DEFAULT;
        }

    }

    public void beforeUpdate() {
        gmtModified = new Date();
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Date getExpirationDate() {
        return expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Integer getRejectStrategy() {
        return rejectStrategy;
    }

    public void setRejectStrategy(Integer rejectStrategy) {
        this.rejectStrategy = rejectStrategy;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }


}
