package cn.com.duiba.anticheat.center.biz.enums;

/**
 * 风控数据层开关
 * Created by sty on 2018/8/9.
 */
public enum AnticheatSwitchEnum {
  USER_IP(0,"用户的ip统计"),
  USER_BE_HELPED(1,"用户被助力在一段时间的统计"),
  USER_MAX_IP_HELPED(2,"已废弃。用户在一段时间内某个ip为他助力最大次数"),
  ALIPAY_ACCOUNT(3,"支付宝账号校验"),
  ALIPAY_NAME(4,"支付宝姓名统计"),
  ALIPAY_ACCOUNT_USER(5,"支付宝账号下的用户数"),
  ALIPAY_NAME_USER(6,"支付宝账号下的名字数"),
  IP_UA_CIDNUM(7,"ip、ua对应的用户数量"),
  IP_ASK(8,"一分钟内单个IP请求频次"),
  IP_USERNUM(9,"单个IP对应cid数量"),
  USER_MAX_IP_UA_HELPED(10,"用户在一段时间内某个ip、ua为他助力最大次数"),
  USER_IP_TOTAL_HELPED(11,"一个用户被某个ip助力的最大次数"),
  DAY_IP_USERNUM(12,"每天一个ip下面的用户数"),
  DAY_INVITE_USERNUM(13,"每天一个用户邀请的人数"),
  USER_IP_NUM_1HOUR(14, "同一用户对应IP数量（1小时内）"),
  ALIPAY_ACCOUNT_WITH_UA_TIMES(15, "同一支付宝账号对应UA数"),
  ALIPAY_ACCOUNT_TIMES_1DAY(16, "同一支付宝账号提现次数（1自然日内））"),
  IP_UA_CIDNUM_1DAY(17,"一天内，ip、ua对应的用户数量"),
  ;

  AnticheatSwitchEnum(Integer code, String desc){
    this.code = code;
    this.desc = desc;
  }
  private Integer code;

  private String desc;

  public Integer getCode() {
    return code;
  }

  public String getDesc() {
    return desc;
  }
}
