package cn.com.duiba.anticheat.center.biz.handler;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 场景注册器
 * Created by sty on 2018/8/6.
 */
public class AntiSceneHandlerRegister {

  private AntiSceneHandlerRegister() {
    // constructor
  }

  private static final Map<Integer, AntiSceneHandler> ANTI_SCENE_HANDLER = Maps.newHashMap();

  public static AntiSceneHandler getHandler(Integer type) {
    return ANTI_SCENE_HANDLER.get(type);
  }

  public static void registerHandler(AntiSceneHandler antiSceneHandler) {
    ANTI_SCENE_HANDLER.put(antiSceneHandler.getSceneType(), antiSceneHandler);
  }
}
