package cn.com.duiba.anticheat.center.biz.service.rules;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by sty on 2018/8/21.
 */
public class DataServerHandlerManager {

  private DataServerHandlerManager() {
    // This constructor is empty.
  }

  private static final Map<Integer, DataServerHandler> DATA_SERVER_HANDLERS = Maps.newHashMap();

  public static DataServerHandler getHandler(Integer type) {
    return DATA_SERVER_HANDLERS.get(type);
  }

  public static void registerHandler(DataServerHandler dataServerHandler) {
    DATA_SERVER_HANDLERS.put(dataServerHandler.getServerNum().getCode(), dataServerHandler);
  }
}
