package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.enums.HbaseKeyEnum;
import cn.com.duiba.anticheat.center.biz.service.hbase.DuibaHbaseRiskService;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;

/**
 * 支付宝名字统计
 * Created by sty on 2018/8/22.
 */
@Service
public class AlipayNameHandler implements DataServerHandler {

  @Autowired
  private DuibaHbaseRiskService duibaHbaseRiskService;
  @Autowired
  private SwitchService switchService;

  @PostConstruct
  public void init(){
    DataServerHandlerManager.registerHandler(this);
  }

  @Override
  public <T extends DuibaBaseModel> void countService(T model) {
    // This implementation is empty.
  }

  @Override
  public Long getService(DuibaActivityModel model) {
    return 0L;
  }

  @Override
  public Long setAndGetService(DuibaActivityModel model) {
    if(model == null){
      return 0L;
    }

    String alipayName = model.getAlipayName();

    if(!switchService.getIsOpen(AnticheatSwitchEnum.ALIPAY_NAME)|| StringUtils.isEmpty(alipayName) ){
      return 0L;
    }

    String userKey = hbaseKey(alipayName);
    return duibaHbaseRiskService.increaseByKey(userKey,1L);
  }

  private String hbaseKey(String alipayName){
    return HbaseKeyEnum.K009.toString() + alipayName;
  }

  @Override
  public AnticheatSwitchEnum getServerNum() {
    return AnticheatSwitchEnum.ALIPAY_NAME;
  }
}
