package cn.com.duiba.anticheat.center.biz.strategy.activity.impl;

import cn.com.duiba.anticheat.center.api.domain.activity.LotteryConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryOrderParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryRequestParams;
import cn.com.duiba.anticheat.center.biz.dao.activity.AnticheatLotteryDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.activity.AnticheatLotteryStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 同一个用户，连续两次兑换时间间隔小于1秒钟，则命中该策略
 * 
 * @author Yanf Guo
 */
@Component
public class AnticheatLotteryLessOneSecStrategy implements AnticheatLotteryStrategy {

	/**
	 * key: consumerId value: timestamp
	 */
	private static final Map<Long, Long> lessOneSecMap = new ConcurrentHashMap<Long, Long>();

	/**
	 * 清空map，每天凌晨给定时器调用
	 */
	public static void clearMap() {
		lessOneSecMap.clear();
	}
	
	@Autowired
	private AnticheatLotteryStrategyConfigService anticheatLotteryStrategyConfigService;

	@Autowired
	private AnticheatLotteryDebugLogDao anticheatLotteryDebugLogDao;

	@Override
	public int getEffectMode() {
		return anticheatLotteryStrategyConfigService.getCacheConfig(AnticheatLotteryStrategyConfigEntity.TYPE_LESS_ONE_SEC).getEffectMode();
	}

	@Override
	public boolean isEnable() {
		return anticheatLotteryStrategyConfigService.getCacheConfig(AnticheatLotteryStrategyConfigEntity.TYPE_LESS_ONE_SEC).getEnable();
	}

	@Override
	public boolean isAppEnable(Long appId) {
		Map<Long, AnticheatLotteryStrategyAppConfigEntity> map = anticheatLotteryStrategyConfigService.getCacheAppConfig(AnticheatLotteryStrategyConfigEntity.TYPE_LESS_ONE_SEC);
		if (!map.containsKey(appId)) {
			return false;
		}
		return true;
	}

	@Override
	public AnticheatLotteryStrategyResult checkLottery(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
		Long consumerId = consumer.getConsumerId();
		Long preTimestamp = lessOneSecMap.get(consumerId);

		Date now = new Date();
		lessOneSecMap.put(consumerId, now.getTime());
		if (preTimestamp == null) { 
			// 该用户前一次兑换时间为NULL，那么表示为当天首次兑换
		} else if ((now.getTime() - preTimestamp) < 1000) {
			Long debugId = doMatchProcess(consumer, order, request);
			return new AnticheatLotteryStrategyResult(true, debugId);
		}
		return new AnticheatLotteryStrategyResult(false);
	}

	private Long doMatchProcess(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
		AnticheatLotteryDebugLogEntity debug = new AnticheatLotteryDebugLogEntity();
		debug.setStrategyType(AnticheatLotteryStrategyConfigEntity.TYPE_LESS_ONE_SEC);
		debug.setConsumerId(consumer.getConsumerId());
		debug.setPartnerUserId(consumer.getPartnerUserId());
		debug.setIp(request.getIp());
		debug.setLotteryOrderId(order.getLotteryOrderId());
		debug.setRelationId(order.getDuibaActivityId());
		debug.setRelationType(order.getType().value());
		debug.setOperatingActivityId(order.getOperatingActivityId());
		debug.setAppId(order.getAppId());
		debug.setMessage("连续两次抽奖时间间隔小于一秒,consumer=" + consumer.getConsumerId());
		anticheatLotteryDebugLogDao.insert(debug);

		return debug.getId();
	}

}
