package cn.com.duiba.anticheat.center.biz.strategy.activity.impl;

import cn.com.duiba.anticheat.center.api.domain.activity.LotteryConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryOrderParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryRequestParams;
import cn.com.duiba.anticheat.center.biz.dao.activity.AnticheatLotteryDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.activity.AnticheatLotteryStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

/**
 * 相同APP，相同抽奖活动，最近20个用户第一次抽奖中,累计四个用户是：UA=xx，第一次抽奖积分=yy，那么第五个用户，UA=xx，第一次抽奖积分=
 * yy的抽奖，不中奖
 * 
 * @author Yanf Guo
 */
@Component
public class AnticheatLotterySameUaCreditsStrategy implements AnticheatLotteryStrategy {

	private static final int RANGE_VALUE = 20; // 匹配范围

	private static final int MATCH_VALUE = 4; // 匹配值

	@Autowired
	private AnticheatLotteryStrategyConfigService anticheatLotteryStrategyConfigService;

	@Autowired
	private AnticheatLotteryDebugLogDao anticheatLotteryDebugLogDao;

	@Override
	public int getEffectMode() {
		return anticheatLotteryStrategyConfigService.getCacheConfig(AnticheatLotteryStrategyConfigEntity.TYPE_SAME_UA_CREDITS_20_4).getEffectMode();
	}

	@Override
	public boolean isEnable() {
		return anticheatLotteryStrategyConfigService.getCacheConfig(AnticheatLotteryStrategyConfigEntity.TYPE_SAME_UA_CREDITS_20_4).getEnable();
	}

	@Override
	public boolean isAppEnable(Long appId) {
		Map<Long, AnticheatLotteryStrategyAppConfigEntity> map = anticheatLotteryStrategyConfigService.getCacheAppConfig(AnticheatLotteryStrategyConfigEntity.TYPE_SAME_UA_CREDITS_20_4);
		return map.containsKey(appId);
	}

	@Override
	public AnticheatLotteryStrategyResult checkLottery(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
		Long appId = consumer.getAppId();
		Integer type = order.getType().value();
		Long duibaActivityId = order.getDuibaActivityId();
		Long credits = order.getCredits();
		String ua = request.getUserAgent();
		Long consumerId = consumer.getConsumerId();
		if (check(appId, type, duibaActivityId, credits, ua, consumerId)) {
			Long debugId = doMatchProcess(consumer, order, request);
			return new AnticheatLotteryStrategyResult(true, debugId);
		}
		return new AnticheatLotteryStrategyResult(false);
	}

	private Map<String, Queue<Model>> data = new HashMap<>();

	private class Model {
		private Long appId;
		private Long duibaActivityId; // 兑吧的活动ID duiba_single_lottery duiba_hdtool
		private Integer type; // 1表示单品，2表示活动工具
		private Long credits;
		private String ua;
		private Long consumerId;

		public boolean equalsTo(Model obj) {
			boolean ret = obj.appId.equals(this.appId) && obj.duibaActivityId.equals(this.duibaActivityId)
					&& obj.type.equals(this.type) && (obj.credits.equals(this.credits));
			return ret && obj.ua != null && obj.ua.equals(ua);
		}
		
		public boolean consumerIdEqualsTo(Long consumerId) {
			return this.consumerId.equals(consumerId);
		}
	}

	public boolean check(Long appId, Integer type, Long duibaActivityId, Long credits, String ua, Long consumerId) {
        if (duibaActivityId == null) {
            duibaActivityId = 0L;
        }
		Model model = new Model();
		model.appId = appId;
		model.type = type;
		model.duibaActivityId = duibaActivityId;
		model.credits = credits;
		model.ua = ua;
		model.consumerId = consumerId;

		String datakey = getDataKey(model.appId, model.type, model.duibaActivityId);
		Queue<Model> queue = data.get(datakey);
		if (queue == null) {
			queue = new LinkedBlockingQueue<>();
			data.put(datakey, queue);
		} else {
			for (Iterator<Model> it = queue.iterator(); it.hasNext();) {
				if (it.next().consumerIdEqualsTo(consumerId)) {
					return false;
				}
			}
		}
		queue.offer(model);

		while (queue.size() > RANGE_VALUE) {
			queue.poll();
		}

		int count = 0;
		for (Iterator<Model> it = queue.iterator(); it.hasNext();) {
			if (it.next().equalsTo(model)) {
				count++;
			}
		}
		if (count > MATCH_VALUE) {
			return true;
		}
		return false;
	}

	private String getDataKey(Long appId, Integer type, Long duibaActivityId) {
		return appId + "-" + type + "-" + duibaActivityId;
	}

	private Long doMatchProcess(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
		AnticheatLotteryDebugLogEntity debug = new AnticheatLotteryDebugLogEntity();
		debug.setStrategyType(AnticheatLotteryStrategyConfigEntity.TYPE_SAME_UA_CREDITS_20_4);
		debug.setConsumerId(consumer.getConsumerId());
		debug.setPartnerUserId(consumer.getPartnerUserId());
		debug.setIp(request.getIp());
		debug.setLotteryOrderId(order.getLotteryOrderId());
		debug.setRelationId(order.getDuibaActivityId());
		debug.setRelationType(order.getType().value());
		debug.setOperatingActivityId(order.getOperatingActivityId());
		debug.setAppId(order.getAppId());
		debug.setMessage("相同APP，相同抽奖活动，最近20个不同用户抽奖，累计超过4个，UA相同，积分相同");
		anticheatLotteryDebugLogDao.insert(debug);

		return debug.getId();
	}
}
