package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * app白名单策略
 * Created by xiaoxuda on 2017/3/1.
 */
@Component
public class AnticheatWhiteAppStrategy implements AnticheatStrategy {
    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;

    @Override
    public int getEffectMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_WHITE_APP).getEffectMode();
    }

    @Override
    public int getCheckMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_WHITE_APP).getCheckMode();
    }

    @Override
    public boolean isEnable() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_WHITE_APP).getEnable();
    }

    @Override
    public boolean isBlackMode() {
        return false;
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = anticheatStrategyConfigService
                .getCacheAppConfig(AnticheatStrategyConfigEntity.TYPE_WHITE_APP);
        return map.containsKey(appId);
    }

    @Override
    public AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        if(isAppEnable(consumer.getAppId())){
            return new AnticheatStrategyResult(true);
        }else{
            return new AnticheatStrategyResult(false);
        }
    }
}
