/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.remoteservice.goods.impl;

import cn.com.duiba.anticheat.center.api.constant.StaticListConstant;
import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.OrderParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.api.remoteservice.goods.RemoteAnticheatCheckService;
import cn.com.duiba.anticheat.center.api.result.goods.ACResultDto;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.service.tongdun.FraudApiResponse;
import cn.com.duiba.anticheat.center.biz.service.tongdun.TongdunClient;
import cn.com.duiba.anticheat.center.biz.service.tongdun.TongdunThreadLocal;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatBlackConsumerStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatBlackIpStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatConsumerDayTimesStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatFirstInTimesStartegy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatFirstNoSwipeStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatFirstSameUaCreditsStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatIpDayTimesStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatSameCreditsAddUpStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatSameCreditsStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatSameDeapStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatSameIpStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatSwipeSkipStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatTongDunHighStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatTongDunMiddleStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatWhiteAppStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatWhiteIpStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatWhiteItemStrategy;
import cn.com.duiba.anticheat.center.common.tool.ThreadTool;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.utils.DateUtils;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="remoteAnticheatCheckService")
public class RemoteAnticheatCheckServiceImpl
implements InitializingBean,
RemoteAnticheatCheckService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteAnticheatCheckServiceImpl.class);
    @Autowired
    private AnticheatBlackIpStrategy anticheatBlackIpStrategy;
    @Autowired
    private AnticheatWhiteIpStrategy anticheatWhiteIpStrategy;
    @Autowired
    private AnticheatSameCreditsStrategy anticheatSameCreditsStrategy;
    @Autowired
    private AnticheatIpDayTimesStrategy anticheatIpDayTimesStrategy;
    @Autowired
    private AnticheatConsumerDayTimesStrategy anticheatConsumerDayTimesStrategy;
    @Autowired
    private AnticheatSwipeSkipStrategy anticheatSwipeSkipStrategy;
    @Autowired
    private AnticheatSameDeapStrategy anticheatSameDeapStrategy;
    @Autowired
    private AnticheatFirstInTimesStartegy anticheatFirstInTimesStartegy;
    @Autowired
    private AnticheatFirstNoSwipeStrategy anticheatFirstNoSwipeStrategy;
    @Autowired
    private AnticheatSameCreditsAddUpStrategy anticheatSameCreditsAddUpStrategy;
    @Autowired
    private AnticheatSameIpStrategy anticheatSameIpStrategy;
    @Autowired
    private AnticheatBlackConsumerStrategy anticheatBlackConsumerStrategy;
    @Autowired
    private AnticheatFirstSameUaCreditsStrategy anticheatFirstSameUaCreditsStrategy;
    @Autowired
    private AnticheatWhiteItemStrategy anticheatWhiteItemStrategy;
    @Autowired
    private AnticheatTongDunMiddleStrategy anticheatTongDunMiddleStrategy;
    @Autowired
    private AnticheatTongDunHighStrategy anticheatTongDunHighStrategy;
    @Autowired
    private AnticheatWhiteAppStrategy anticheatWhiteAppStrategy;
    @Resource
    private ExecutorService executorService;
    @Resource
    private ScheduledExecutorService scheduledExecutorService;
    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;
    @Resource(name="redisTemplate")
    private RedisAtomicClient redisAtomicClient;
    private static final int CIRCLE = 5;
    private static final int TIMEOUT_TIME = 150;
    private static final Semaphore SEMAPHORE = new Semaphore(100);
    private List<AnticheatStrategy> tongDunStrategies = new ArrayList<AnticheatStrategy>();
    private List<AnticheatStrategy> whiteStrategies = new ArrayList<AnticheatStrategy>();
    private List<AnticheatStrategy> blackStrategies = new ArrayList<AnticheatStrategy>();

    public void afterPropertiesSet() throws Exception {
        this.tongDunStrategies.add(this.anticheatTongDunMiddleStrategy);
        this.tongDunStrategies.add(this.anticheatTongDunHighStrategy);
        this.blackStrategies.add(this.anticheatBlackIpStrategy);
        this.blackStrategies.add(this.anticheatSameCreditsStrategy);
        this.blackStrategies.add(this.anticheatIpDayTimesStrategy);
        this.blackStrategies.add(this.anticheatConsumerDayTimesStrategy);
        this.blackStrategies.add(this.anticheatSwipeSkipStrategy);
        this.blackStrategies.add(this.anticheatSameDeapStrategy);
        this.blackStrategies.add(this.anticheatFirstInTimesStartegy);
        this.blackStrategies.add(this.anticheatFirstNoSwipeStrategy);
        this.blackStrategies.add(this.anticheatSameCreditsAddUpStrategy);
        this.blackStrategies.add(this.anticheatSameIpStrategy);
        this.blackStrategies.add(this.anticheatBlackConsumerStrategy);
        this.blackStrategies.add(this.anticheatFirstSameUaCreditsStrategy);
        this.whiteStrategies.add(this.anticheatWhiteAppStrategy);
        this.whiteStrategies.add(this.anticheatWhiteIpStrategy);
        this.whiteStrategies.add(this.anticheatWhiteItemStrategy);
        this.sortScheduler();
    }

    private String getIpKey(String ip) {
        return "103-ip-" + ip;
    }

    private String getConsumerKey(Long cid) {
        return "103-cid-" + cid;
    }

    public DubboResult<Void> onOrderCreate(OrderParams order) {
        try {
            String ipKey = this.getIpKey(order.getIp());
            this.redisAtomicClient.incrBy(ipKey, 1L, (long)DateUtils.getToTomorrowSeconds(), TimeUnit.SECONDS);
            String cidKey = this.getConsumerKey(order.getConsumerId());
            this.redisAtomicClient.incrBy(cidKey, 1L, (long)DateUtils.getToTomorrowSeconds(), TimeUnit.SECONDS);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOGGER.error("onOrderCreate, error", (Throwable)e);
            return DubboResult.failResult((String)"onOrderCreate, error");
        }
    }

    public DubboResult<Void> onOrderFail(OrderParams order) {
        try {
            String ipKey = this.getIpKey(order.getIp());
            this.redisAtomicClient.incrBy(ipKey, -1L, (long)DateUtils.getToTomorrowSeconds(), TimeUnit.SECONDS);
            String cidKey = this.getConsumerKey(order.getConsumerId());
            this.redisAtomicClient.incrBy(cidKey, -1L, (long)DateUtils.getToTomorrowSeconds(), TimeUnit.SECONDS);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOGGER.error("onOrderFail, error", (Throwable)e);
            return DubboResult.failResult((String)"onOrderFail, \u5f02\u5e38");
        }
    }

    public DubboResult<ACResultDto> checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        return this.check(consumer, goods, request, behavior, new ACResultDto(true, null, null, Integer.valueOf(0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DubboResult<ACResultDto> check(final ConsumerParams consumer, final GoodsParams goods, final RequestParams request, final BehaviorParams behavior, ACResultDto defaultResult) {
        if (StaticListConstant.matchWhiteApp((Long)consumer.getAppId())) {
            return DubboResult.successResult((Object)new ACResultDto(true, null, null, Integer.valueOf(0)));
        }
        Callable<DubboResult<ACResultDto>> callable = new Callable<DubboResult<ACResultDto>>(){

            @Override
            public DubboResult<ACResultDto> call() throws Exception {
                ACResultDto result = RemoteAnticheatCheckServiceImpl.this.innerCheckCouponExchange(consumer, goods, request, behavior);
                return DubboResult.successResult((Object)result);
            }
        };
        if (SEMAPHORE.tryAcquire()) {
            Future<DubboResult<ACResultDto>> future = null;
            try {
                future = this.executorService.submit(callable);
                DubboResult result = future.get(150L, TimeUnit.MILLISECONDS);
                DubboResult dubboResult = result != null ? result : DubboResult.successResult((Object)defaultResult);
                return dubboResult;
            }
            catch (TimeoutException e) {
                LOGGER.info("\u5151\u6362\u9879\u9632\u4f5c\u5f0a\u964d\u7ea7,\u4e1a\u52a1\u8d85\u65f6, errMsg={}", (Object)e.getMessage());
                LOGGER.debug("\u5151\u6362\u9879\u9632\u4f5c\u5f0a\u964d\u7ea7,\u4e1a\u52a1\u8d85\u65f6", (Throwable)e);
                ThreadTool.cancelTask(future);
                DubboResult dubboResult = DubboResult.successResult((Object)defaultResult);
                return dubboResult;
            }
            catch (Exception e) {
                LOGGER.warn("\u5151\u6362\u9879\u9632\u4f5c\u5f0a\u964d\u7ea7,\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                ThreadTool.cancelTask(future);
                DubboResult dubboResult = DubboResult.successResult((Object)defaultResult);
                return dubboResult;
            }
            finally {
                SEMAPHORE.release();
            }
        }
        LOGGER.info("\u5151\u6362\u9879\u9632\u4f5c\u5f0a\u964d\u7ea7\u901a\u8fc7,\u6d41\u91cf\u8d85\u4e86\uff1aconsumerId={}, gtype={}, gid={}", new Object[]{consumer.getConsumerId(), goods.getGtype(), goods.getGid()});
        return DubboResult.successResult((Object)defaultResult);
    }

    public DubboResult<ACResultDto> checkGoodsWebExchange(ConsumerParams consumer, GoodsParams item, RequestParams request, BehaviorParams behavior) {
        return this.check(consumer, item, request, behavior, new ACResultDto(false, null, null, Integer.valueOf(1)));
    }

    public DubboResult<Void> fillbackDebugIds(List<Long> debugIds, Long orderId) {
        try {
            for (Long it : debugIds) {
                AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(it);
                debug.setOrderId(orderId);
                this.anticheatDebugLogDao.update(debug);
            }
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOGGER.error("\u56de\u586b dubugIds \u5f02\u5e38", (Throwable)e);
            return DubboResult.failResult((String)"\u56de\u586b debugIds \u5f02\u5e38");
        }
    }

    private ACResultDto innerCheckCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        ArrayList<Long> debugIds = new ArrayList<Long>();
        ACResultDto ret = this.whiteStrategyMatch(consumer, goods, request, behavior, debugIds);
        if (ret != null) {
            return ret;
        }
        ret = this.blackStrategyMatch(consumer, goods, request, behavior, debugIds, this.blackStrategies);
        if (ret != null) {
            return ret;
        }
        ret = this.tongDunStrategyMatch(consumer, goods, request, behavior, debugIds);
        if (ret != null) {
            return ret;
        }
        return new ACResultDto(true, null, debugIds, Integer.valueOf(0));
    }

    private ACResultDto whiteStrategyMatch(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior, List<Long> debugIds) {
        for (AnticheatStrategy as : this.whiteStrategies) {
            Transaction t = Cat.newTransaction((String)"URL", (String)as.getClass().getSimpleName());
            try {
                AnticheatStrategy.AnticheatStrategyResult ret = as.checkCouponExchangeFast(consumer, goods, request, behavior);
                t.setStatus("0");
                if (ret.isMatch()) {
                    debugIds.add(ret.getDebugId());
                }
                if (!this.judgeMatch(ret, as, consumer)) continue;
                ACResultDto aCResultDto = new ACResultDto(true, "", debugIds, Integer.valueOf(0));
                return aCResultDto;
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                throw e;
            }
            finally {
                t.complete();
            }
        }
        return null;
    }

    private ACResultDto tongDunStrategyMatch(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior, List<Long> debugIds) {
        ArrayList<AnticheatStrategy> targetStrategies = new ArrayList<AnticheatStrategy>();
        for (AnticheatStrategy strategy : this.tongDunStrategies) {
            if (!strategy.needValid(consumer)) continue;
            targetStrategies.add(strategy);
        }
        if (targetStrategies.isEmpty()) {
            return null;
        }
        FraudApiResponse response = TongdunClient.checkExchangeTongdun(consumer, goods, request);
        TongdunThreadLocal.get().setApiResponse(response);
        return this.blackStrategyMatch(consumer, goods, request, behavior, debugIds, targetStrategies);
    }

    private ACResultDto blackStrategyMatch(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior, List<Long> debugIds, List<AnticheatStrategy> strategies) {
        for (AnticheatStrategy as : strategies) {
            Transaction t = Cat.newTransaction((String)"URL", (String)as.getClass().getSimpleName());
            try {
                AnticheatStrategy.AnticheatStrategyResult ret = as.checkCouponExchangeFast(consumer, goods, request, behavior);
                t.setStatus("0");
                if (ret.isMatch()) {
                    debugIds.add(ret.getDebugId());
                }
                if (!this.judgeMatch(ret, as, consumer)) continue;
                ACResultDto aCResultDto = new ACResultDto(false, "\u9ed1\u540d\u5355\u547d\u4e2d", debugIds, this.getCheckMode(as.getCheckMode()));
                return aCResultDto;
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                throw e;
            }
            finally {
                t.complete();
            }
        }
        return null;
    }

    public List<AnticheatStrategy> sortBlackStrategies(List<AnticheatStrategy> list) {
        Collections.sort(list, new Comparator<AnticheatStrategy>(){

            @Override
            public int compare(AnticheatStrategy o1, AnticheatStrategy o2) {
                int ib = this.compareBoolean(o1.isEnable(), o2.isEnable());
                if (ib != 0) {
                    return ib;
                }
                return this.compareInt(o1.getCheckMode(), o2.getCheckMode());
            }

            private int compareInt(int i1, int i2) {
                if (i1 == i2) {
                    return 0;
                }
                if (i1 == 0) {
                    return -1;
                }
                return 1;
            }

            private int compareBoolean(boolean b1, boolean b2) {
                if (b1 == b2) {
                    return 0;
                }
                if (b1) {
                    return -1;
                }
                return 1;
            }
        });
        return list;
    }

    private void sortScheduler() {
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> {
            ArrayList<AnticheatStrategy> newList = new ArrayList<AnticheatStrategy>(this.blackStrategies);
            this.blackStrategies = this.sortBlackStrategies(newList);
            LOGGER.info("\u9ed1\u540d\u5355\u7b56\u7565\u6392\u5e8f\u626b\u63cf\u6267\u884c~");
        }, 0L, 5L, TimeUnit.MINUTES);
    }

    private boolean judgeMatch(AnticheatStrategy.AnticheatStrategyResult ret, AnticheatStrategy as, ConsumerParams consumer) {
        if (!ret.isMatch()) {
            return false;
        }
        return as.needValid(consumer);
    }

    private Integer getCheckMode(int checkMode) {
        if (checkMode == 0) {
            return 0;
        }
        if (checkMode == 1) {
            return 1;
        }
        return null;
    }
}

