/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.risk.impl;

import cn.com.duiba.anticheat.center.api.dto.ActRiskRechargeConfDto;
import cn.com.duiba.anticheat.center.api.param.ActRiskRechargeConfParam;
import cn.com.duiba.anticheat.center.biz.constant.RedisKeyFactory;
import cn.com.duiba.anticheat.center.biz.dao.risk.ActRiskRechargeConfDao;
import cn.com.duiba.anticheat.center.biz.entity.risk.ActRiskRechargeConfEntity;
import cn.com.duiba.anticheat.center.biz.service.risk.RiskActRechargeConfService;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class RiskActRechargeConfServiceImpl
implements RiskActRechargeConfService {
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private ActRiskRechargeConfDao actRiskRechargeConfDao;

    @Override
    public boolean insertSelective(ActRiskRechargeConfDto dto) throws BizException {
        if (dto == null || dto.getActivityType() == null || StringUtils.isBlank((CharSequence)dto.getRelationId())) {
            throw new BizException("\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (this.getByParam(dto) != null) {
            return false;
        }
        if (this.actRiskRechargeConfDao.insertSelective((ActRiskRechargeConfEntity)BeanUtils.copy((Object)dto, ActRiskRechargeConfEntity.class)) > 0) {
            this.stringRedisTemplate.delete((Object)this.getKey(dto.getActivityType(), dto.getRelationId()));
            return true;
        }
        return false;
    }

    @Override
    public boolean updateByPrimaryKeySelective(ActRiskRechargeConfDto dto) throws BizException {
        if (dto == null || dto.getId() == null) {
            throw new BizException("\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (this.getByParam(dto) == null) {
            return false;
        }
        if (this.actRiskRechargeConfDao.updateByPrimaryKeySelective((ActRiskRechargeConfEntity)BeanUtils.copy((Object)dto, ActRiskRechargeConfEntity.class)) > 0) {
            ActRiskRechargeConfDto copy = (ActRiskRechargeConfDto)BeanUtils.copy((Object)this.getByParam(dto), ActRiskRechargeConfDto.class);
            String key = this.getKey(copy.getActivityType(), copy.getRelationId());
            if (key != null) {
                this.stringRedisTemplate.opsForValue().set((Object)key, (Object)JSONObject.toJSONString((Object)copy), 5L, TimeUnit.MINUTES);
            }
            return true;
        }
        return false;
    }

    @Override
    public ActRiskRechargeConfDto selectByParam(String relationId, Long activityType) throws BizException {
        if (activityType == null || StringUtils.isBlank((CharSequence)relationId)) {
            throw new BizException("\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        }
        String key = this.getKey(activityType, relationId);
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return (ActRiskRechargeConfDto)JSONObject.parseObject((String)value, ActRiskRechargeConfDto.class);
        }
        ActRiskRechargeConfParam param = new ActRiskRechargeConfParam();
        param.setRelationId(relationId);
        param.setActivityType(activityType);
        ActRiskRechargeConfDto dto = (ActRiskRechargeConfDto)BeanUtils.copy((Object)this.actRiskRechargeConfDao.selectByParam(param), ActRiskRechargeConfDto.class);
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)JSONObject.toJSONString((Object)dto), 5L, TimeUnit.MINUTES);
        return dto;
    }

    private String getKey(Long activityType, String relationId) {
        if (activityType == null || relationId == null) {
            return null;
        }
        return String.format("%s%s_%s", RedisKeyFactory.K033.toString(), activityType, relationId);
    }

    private ActRiskRechargeConfEntity getByParam(ActRiskRechargeConfDto dto) {
        ActRiskRechargeConfParam param = new ActRiskRechargeConfParam();
        param.setActivityType(dto.getActivityType());
        param.setRelationId(dto.getRelationId());
        param.setId(dto.getId());
        return this.actRiskRechargeConfDao.selectByParam(param);
    }

    @Override
    public ActRiskRechargeConfDto selectById(Long id) throws BizException {
        if (id == null) {
            throw new BizException("\u53c2\u6570\u4e3a\u7a7a");
        }
        ActRiskRechargeConfParam param = new ActRiskRechargeConfParam();
        param.setId(id);
        return (ActRiskRechargeConfDto)BeanUtils.copy((Object)this.actRiskRechargeConfDao.selectByParam(param), ActRiskRechargeConfDto.class);
    }
}

