/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.enums.HbaseKeyEnum;
import cn.com.duiba.anticheat.center.biz.service.hbase.DuibaHbaseRiskService;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlipayAccountWithUserHandler
implements DataServerHandler {
    @Autowired
    private SwitchService switchService;
    @Autowired
    private DuibaHbaseRiskService duibaHbaseRiskService;

    @PostConstruct
    public void init() {
        DataServerHandlerManager.registerHandler(this);
    }

    @Override
    public <T extends DuibaBaseModel> void countService(T model) {
    }

    @Override
    public Long getService(DuibaActivityModel model) {
        return 0L;
    }

    @Override
    public Long setAndGetService(DuibaActivityModel model) {
        if (model == null) {
            return 0L;
        }
        Long consumerId = model.getConsumerId();
        String alipayAccount = model.getAlipayAccount();
        if (!this.switchService.getIsOpen(AnticheatSwitchEnum.ALIPAY_ACCOUNT_USER) || consumerId == null || StringUtils.isEmpty((CharSequence)alipayAccount)) {
            return 0L;
        }
        String userKey = this.hbaseKey(alipayAccount, String.valueOf(consumerId));
        String userNumKey = this.hbaseKey(alipayAccount, "alipayAccountUserNum");
        Long curUser = this.duibaHbaseRiskService.findByRowKey(userKey);
        if (curUser == null) {
            this.duibaHbaseRiskService.upsert(userKey, 1L);
            return this.duibaHbaseRiskService.increaseByKey(userNumKey, 1L);
        }
        return this.duibaHbaseRiskService.findByRowKey(userNumKey);
    }

    private String hbaseKey(String alipayAccount, String key) {
        return HbaseKeyEnum.K006.toString() + alipayAccount + key;
    }

    @Override
    public AnticheatSwitchEnum getServerNum() {
        return AnticheatSwitchEnum.ALIPAY_ACCOUNT_USER;
    }
}

