/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.api.model.HelpCodeModel;
import cn.com.duiba.anticheat.center.biz.constant.RedisKeyFactory;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class BeHelpNumInSecondsHandler
implements DataServerHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeHelpNumInSecondsHandler.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private SwitchService switchService;

    @PostConstruct
    public void init() {
        DataServerHandlerManager.registerHandler(this);
    }

    @Override
    public <T extends DuibaBaseModel> void countService(T model) {
        if (model == null) {
            return;
        }
        if (model instanceof HelpCodeModel) {
            HelpCodeModel duibaActivityModel = (HelpCodeModel)model;
            this.getBeHelpedNum(duibaActivityModel.getConsumerId(), duibaActivityModel.getAppId(), duibaActivityModel.getActivityId(), 1L);
        }
    }

    @Override
    public Long getService(DuibaActivityModel model) {
        if (model == null) {
            return 0L;
        }
        return this.getBeHelpedNum(model.getConsumerId(), model.getAppId(), model.getActivityId(), 0L);
    }

    @Override
    public Long setAndGetService(DuibaActivityModel model) {
        LOGGER.warn("10s\u5185\u7528\u6237\u52a9\u529b\u6b21\u6570\u89c4\u5219\u4e0d\u652f\u6301\u8bbe\u7f6e\u540e\u76f4\u63a5\u53d6\u503c");
        return 0L;
    }

    @Override
    public AnticheatSwitchEnum getServerNum() {
        return AnticheatSwitchEnum.USER_BE_HELPED;
    }

    private Long getBeHelpedNum(Long consumerId, Long appId, Long activityId, Long num) {
        if (!this.switchService.getIsOpen(AnticheatSwitchEnum.USER_BE_HELPED) || consumerId == null || appId == null || activityId == null || num == null || num != 1L && num != 0L) {
            return 0L;
        }
        String redisKey = RedisKeyFactory.K011.toString() + consumerId + "_" + appId + "_" + activityId;
        Long times = this.stringRedisTemplate.opsForValue().increment((Object)redisKey, num.longValue());
        if (this.stringRedisTemplate.getExpire((Object)redisKey) == -1L) {
            this.stringRedisTemplate.expire((Object)redisKey, 10L, TimeUnit.SECONDS);
        }
        return times;
    }
}

