/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.enums.HbaseKeyEnum;
import cn.com.duiba.anticheat.center.biz.service.hbase.DuibaHbaseRiskService;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DayIpWithUserHandler
implements DataServerHandler {
    @Autowired
    private SwitchService switchService;
    @Autowired
    private DuibaHbaseRiskService duibaHbaseRiskService;

    @PostConstruct
    public void init() {
        DataServerHandlerManager.registerHandler(this);
    }

    @Override
    public <T extends DuibaBaseModel> void countService(T model) {
    }

    @Override
    public Long getService(DuibaActivityModel model) {
        return 0L;
    }

    @Override
    public Long setAndGetService(DuibaActivityModel model) {
        if (model == null) {
            return 0L;
        }
        Long consumerId = model.getConsumerId();
        Long appId = model.getAppId();
        Long activityId = model.getActivityId();
        String ip = model.getIp();
        if (!this.switchService.getIsOpen(AnticheatSwitchEnum.DAY_IP_USERNUM) || consumerId == null || appId == null || activityId == null || StringUtils.isBlank((CharSequence)ip)) {
            return 0L;
        }
        String hbaseUserKey = this.getDayIpUserHbaseKey(appId, activityId, ip, String.valueOf(consumerId));
        Long ipWithUser = this.duibaHbaseRiskService.findByRowKey(hbaseUserKey);
        String hbaseNumKey = this.getDayIpUserHbaseKey(appId, activityId, ip, "dayIpWithUserNum");
        if (ipWithUser == null) {
            this.duibaHbaseRiskService.upsert(hbaseUserKey, 1L);
            this.duibaHbaseRiskService.increaseByKey(hbaseNumKey, 1L);
        }
        return this.duibaHbaseRiskService.findByRowKey(hbaseNumKey);
    }

    private String getDayIpUserHbaseKey(Long appId, Long activityId, String ip, String key) {
        return HbaseKeyEnum.K010.toString() + appId + "_" + activityId + "_" + DateUtils.getDayStr((Date)new Date()) + "_" + ip + "_" + key;
    }

    @Override
    public AnticheatSwitchEnum getServerNum() {
        return AnticheatSwitchEnum.DAY_IP_USERNUM;
    }
}

