/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.enums.HbaseKeyEnum;
import cn.com.duiba.anticheat.center.biz.service.hbase.DuibaHbaseRiskService;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IpUaWithUserHandler
implements DataServerHandler {
    private static final String IP_UA_WITH_USER_NUM = "ipUaWithUserNum";
    @Autowired
    private SwitchService switchService;
    @Autowired
    private DuibaHbaseRiskService duibaHbaseRiskService;

    @PostConstruct
    public void init() {
        DataServerHandlerManager.registerHandler(this);
    }

    @Override
    public <T extends DuibaBaseModel> void countService(T model) {
    }

    @Override
    public Long getService(DuibaActivityModel model) {
        return 0L;
    }

    @Override
    public Long setAndGetService(DuibaActivityModel model) {
        if (model == null) {
            return 0L;
        }
        Long consumerId = model.getConsumerId();
        Long appId = model.getAppId();
        Long activityId = model.getActivityId();
        String ip = model.getIp();
        String ua = model.getUa();
        if (!this.switchService.getIsOpen(AnticheatSwitchEnum.IP_UA_CIDNUM) || consumerId == null || appId == null || activityId == null || StringUtils.isBlank((CharSequence)ip) || StringUtils.isBlank((CharSequence)ua)) {
            return 0L;
        }
        String hbaseUserKey = this.getIpUaUserHbaseKey(appId, activityId, ip, ua, String.valueOf(consumerId));
        Long ipUaWithUser = this.duibaHbaseRiskService.findByRowKey(hbaseUserKey);
        String hbaseNumKey = this.getIpUaUserHbaseKey(appId, activityId, ip, ua, IP_UA_WITH_USER_NUM);
        if (ipUaWithUser == null) {
            this.duibaHbaseRiskService.upsert(hbaseUserKey, 1L);
            this.duibaHbaseRiskService.increaseByKey(hbaseNumKey, 1L);
        }
        return this.duibaHbaseRiskService.findByRowKey(hbaseNumKey);
    }

    private String getIpUaUserHbaseKey(Long appId, Long activityId, String ip, String ua, String key) {
        return HbaseKeyEnum.K002.toString() + appId + "_" + activityId + "_" + ip + "_" + ua + "_" + key;
    }

    @Override
    public AnticheatSwitchEnum getServerNum() {
        return AnticheatSwitchEnum.IP_UA_CIDNUM;
    }
}

