/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.rules.impl;

import cn.com.duiba.anticheat.center.api.enums.RuleSceneEnum;
import cn.com.duiba.anticheat.center.biz.config.RuleAgendaListener;
import cn.com.duiba.anticheat.center.biz.service.rules.RuleExcuteService;
import cn.com.duiba.anticheat.center.biz.service.rules.impl.KieComponent;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.kie.api.KieBase;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.runtime.KieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RuleExcuteServiceImpl
implements RuleExcuteService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleExcuteServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean runRule(RuleSceneEnum scene, List<Object> objects) {
        if (scene == null || CollectionUtils.isEmpty(objects)) {
            return false;
        }
        KieBase kbase = KieComponent.getBaseByScene(scene.getType());
        if (kbase == null) {
            return false;
        }
        KieSession session = kbase.newKieSession();
        try {
            RuleAgendaListener agendaListener = new RuleAgendaListener();
            session.addEventListener((AgendaEventListener)agendaListener);
            objects.forEach(arg_0 -> ((KieSession)session).insert(arg_0));
            session.fireAllRules();
            objects.forEach(one -> session.delete(session.getFactHandle(one)));
            List<String> attachedRuleNames = agendaListener.getAts();
            boolean bl = CollectionUtils.isNotEmpty(attachedRuleNames);
            return bl;
        }
        catch (Exception e) {
            LOGGER.info("\u6267\u884c\u68c0\u6d4b\u89c4\u5219\u51fa\u9519", (Throwable)e);
        }
        finally {
            session.dispose();
        }
        return false;
    }
}

